/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding.converters;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class RectangleToSpatial4JRectangleConverter
implements TwoWayConverter<org.locationtech.spatial4j.shape.Rectangle, Rectangle> {
    @Override
    public org.locationtech.spatial4j.shape.Rectangle backwardConvert(Rectangle other) {
        Location lowerLeft = other.lowerLeft();
        Location upperRight = other.upperRight();
        return new RectangleImpl(lowerLeft.getLongitude().asDegrees(), upperRight.getLongitude().asDegrees(), lowerLeft.getLatitude().asDegrees(), upperRight.getLatitude().asDegrees(), SpatialContext.GEO);
    }

    @Override
    public Rectangle convert(org.locationtech.spatial4j.shape.Rectangle other) {
        return Rectangle.forCorners(new Location(Latitude.degrees(other.getMinY()), Longitude.degrees(other.getMinX())), new Location(Latitude.degrees(other.getMaxY()), Longitude.degrees(other.getMaxX())));
    }
}

