/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.sharding.GeoHashTile;

class GeoHashTileIterable
implements Iterable<GeoHashTile> {
    private final char[] starting;
    private final char[] prefix;
    private final int precision;
    private final GeometricSurface surface;
    private final boolean isMaximum;

    GeoHashTileIterable(int precision) {
        this(precision, Rectangle.MAXIMUM);
    }

    GeoHashTileIterable(int precision, GeometricSurface surface) {
        int index;
        this.precision = precision;
        this.surface = surface;
        this.starting = new char[precision];
        this.prefix = this.prefix();
        this.isMaximum = surface instanceof Rectangle && Rectangle.MAXIMUM.equals(surface);
        for (index = 0; index < this.prefix.length; ++index) {
            this.starting[index] = this.prefix[index];
        }
        for (index = this.prefix.length; index < precision; ++index) {
            this.starting[index] = GeoHashTile.GEOHASH_CHARACTERS[0];
        }
    }

    @Override
    public Iterator<GeoHashTile> iterator() {
        return new GeoHashTileIterator();
    }

    private boolean isMaximum() {
        return this.isMaximum;
    }

    private char[] prefix() {
        if (this.isMaximum()) {
            return new char[0];
        }
        ArrayList<char[]> geoHashes = new ArrayList<char[]>();
        for (Location corner : this.surface.bounds()) {
            geoHashes.add(GeoHashTile.covering(corner, this.precision).toCharArray());
        }
        ArrayList<Character> prefixAsList = new ArrayList<Character>();
        for (int index = 0; index < this.precision; ++index) {
            Character candidate = null;
            boolean valid = true;
            for (int cornerIndex = 0; cornerIndex < geoHashes.size(); ++cornerIndex) {
                char cornerCharacter = ((char[])geoHashes.get(cornerIndex))[index];
                if (candidate == null) {
                    candidate = Character.valueOf(cornerCharacter);
                    continue;
                }
                if (candidate.equals(Character.valueOf(cornerCharacter))) continue;
                valid = false;
                break;
            }
            if (!valid) break;
            prefixAsList.add(candidate);
        }
        char[] result = new char[prefixAsList.size()];
        for (int index = 0; index < prefixAsList.size(); ++index) {
            result[index] = ((Character)prefixAsList.get(index)).charValue();
        }
        return result;
    }

    private class GeoHashTileIterator
    implements Iterator<GeoHashTile> {
        private final char[] current;
        private boolean done;
        private boolean firstCall;
        private int backIndex;

        private GeoHashTileIterator() {
            this.current = Arrays.copyOf(GeoHashTileIterable.this.starting, GeoHashTileIterable.this.precision);
            this.done = false;
            this.firstCall = true;
            this.backIndex = GeoHashTileIterable.this.precision - 1;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public GeoHashTile next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            GeoHashTile result = new GeoHashTile(String.valueOf(this.current));
            if (!GeoHashTileIterable.this.isMaximum() && this.firstCall) {
                while (!this.done && !this.overlaps(result)) {
                    this.upgrade();
                    result = new GeoHashTile(String.valueOf(this.current));
                }
            }
            this.upgrade();
            while (!(GeoHashTileIterable.this.isMaximum() || this.done || this.overlaps(new GeoHashTile(String.valueOf(this.current))))) {
                this.upgrade();
            }
            this.firstCall = false;
            return result;
        }

        private boolean overlaps(GeoHashTile tile) {
            return GeoHashTileIterable.this.surface.overlaps(tile.bounds());
        }

        private void tick(int index) {
            char currentChar = this.current[index];
            int currentCharIndex = (Integer)GeoHashTile.GEOHASH_CHARACTER_MAP.inverse().get(Character.valueOf(currentChar));
            this.current[index] = ((Character)GeoHashTile.GEOHASH_CHARACTER_MAP.get(currentCharIndex + 1)).charValue();
        }

        private void upgrade() {
            char lastCharacter = GeoHashTile.GEOHASH_CHARACTERS[GeoHashTile.GEOHASH_CHARACTERS.length - 1];
            while (this.backIndex >= GeoHashTileIterable.this.prefix.length && this.current[this.backIndex] == lastCharacter) {
                --this.backIndex;
            }
            if (this.backIndex < GeoHashTileIterable.this.prefix.length) {
                this.done = true;
                return;
            }
            this.tick(this.backIndex);
            if (this.backIndex < GeoHashTileIterable.this.precision - 1) {
                this.zero(this.backIndex + 1);
                this.backIndex = GeoHashTileIterable.this.precision - 1;
            }
        }

        private void zero(int index) {
            for (int subIndex = index; subIndex < GeoHashTileIterable.this.precision; ++subIndex) {
                this.current[subIndex] = GeoHashTile.GEOHASH_CHARACTERS[0];
            }
        }
    }
}

