/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.sharding;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.sharding.GeoHashTile;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class GeoHashSharding
implements Sharding {
    private static final long serialVersionUID = -7355746343440111174L;
    private final int precision;

    public GeoHashSharding(int precision) {
        GeoHashTile.validatePrecision(precision);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public Iterable<Shard> neighbors(Shard shard) {
        if (shard instanceof GeoHashTile) {
            return ((GeoHashTile)shard).neighbors();
        }
        throw new CoreException("Shard parameter was of invalid type {}", shard.getClass().getName());
    }

    @Override
    public Shard shardForName(String name) {
        if (name.length() != this.precision) {
            throw new CoreException("This geohash sharding is of precision {}. \"{}\" is not the correct length.", this.precision, name);
        }
        return GeoHashTile.forName(name);
    }

    @Override
    public Iterable<Shard> shards(GeometricSurface surface) {
        return Iterables.stream(GeoHashTile.allTiles(this.precision, surface)).map(tile -> tile);
    }

    @Override
    public Iterable<Shard> shardsCovering(Location location) {
        return Iterables.stream(Iterables.from(GeoHashTile.covering(location, this.precision))).map(tile -> tile);
    }

    @Override
    public Iterable<Shard> shardsIntersecting(PolyLine polyLine) {
        return Iterables.stream(GeoHashTile.allTiles(this.precision, polyLine.bounds())).filter(tile -> tile.bounds().intersects(polyLine)).map(tile -> tile);
    }
}

