/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.impl.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.geojson.parser.GeoJsonParser;
import org.openstreetmap.atlas.geography.geojson.parser.domain.base.GeoJsonItem;
import org.openstreetmap.atlas.geography.geojson.parser.domain.base.type.Type;
import org.openstreetmap.atlas.geography.geojson.parser.domain.base.type.TypeUtil;
import org.openstreetmap.atlas.geography.geojson.parser.mapper.impl.DefaultBeanUtilsBasedMapperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GeoJsonParserGsonImpl implements GeoJsonParser
{
    instance;

    private static final Logger log;

    @Override
    public GeoJsonItem deserialize(String geoJson) {
        log.info("geoJson:: {}.", (Object)geoJson);
        Map<String, Object> map = this.toMap(geoJson);
        return this.deserialize(map);
    }

    @Override
    public GeoJsonItem deserialize(Map<String, Object> map) {
        log.info("map:: {}.", map);
        Type type = TypeUtil.identifyStandardType(this.getType(map));
        return type.construct(instance, map);
    }

    @Override
    public <T> T deserializeExtension(String json, Class<T> targetClass) {
        Map<String, Object> map = this.toMap(json);
        return this.deserializeExtension(map, targetClass);
    }

    @Override
    public <T> T deserializeExtension(Map<String, Object> map, Class<T> targetClass) {
        DefaultBeanUtilsBasedMapperImpl mapper = DefaultBeanUtilsBasedMapperImpl.instance;
        return mapper.map(map, targetClass);
    }

    private String getType(Map<String, Object> map) {
        Object type = map.get("type");
        Validate.isTrue(type instanceof String, "type: %s.", type);
        return (String)type;
    }

    private Map<String, Object> toMap(String geoJson) {
        Gson gson = new GsonBuilder().create();
        return (Map)gson.fromJson(geoJson, Object.class);
    }

    static {
        log = LoggerFactory.getLogger(GeoJsonParserGsonImpl.class);
    }
}

