/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.MultiLineString;
import org.openstreetmap.atlas.geography.geojson.parser.domain.geometry.coordinate.Position;

public final class Positions {
    public static Polygon toAtlasPolygonFromMultiLineString(MultiLineString multiLineString) {
        List<Polygon> atlasPolygons = Positions.toListOfAtlasPolygonsFromMultiLineString(multiLineString, 1);
        Validate.isTrue(atlasPolygons.size() == 1);
        return atlasPolygons.get(0);
    }

    public static List<List<Location>> toCollectionsOfLocations(List<List<Position>> collectionOfPositions) {
        return collectionOfPositions.stream().map(Positions::toLocations).collect(Collectors.toList());
    }

    public static List<Polygon> toListOfAtlasPolygonsFromMultiLineString(MultiLineString multiLineString, int expectedSize) {
        Validate.notNull(multiLineString);
        Validate.notNull(multiLineString.getCoordinates());
        Validate.notEmpty(multiLineString.getCoordinates().getValue());
        if (expectedSize > 0) {
            Validate.isTrue(expectedSize == multiLineString.getCoordinates().getValue().size());
        }
        return multiLineString.getCoordinates().getValue().stream().map(positions -> new Polygon(Positions.toLocations(positions))).collect(Collectors.toList());
    }

    public static List<Polygon> toListOfAtlasPolygonsFromMultiLineString(MultiLineString multiLineString) {
        return Positions.toListOfAtlasPolygonsFromMultiLineString(multiLineString, -1);
    }

    public static Location toLocation(Position position) {
        return new Location(Latitude.degrees(position.getCoordinate2()), Longitude.degrees(position.getCoordinate1()));
    }

    public static List<Location> toLocations(List<Position> positions) {
        return positions.stream().map(Positions::toLocation).collect(Collectors.toList());
    }

    private Positions() {
    }
}

