/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.geojson.parser.domain.bbox;

import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.openstreetmap.atlas.geography.geojson.parser.domain.bbox.Bbox;
import org.openstreetmap.atlas.geography.geojson.parser.domain.bbox.Bbox2D;
import org.openstreetmap.atlas.geography.geojson.parser.domain.bbox.Bbox3D;

public enum Dimensions {
    TWO_DIMENSIONAL(2, Bbox2D.class),
    THREE_DIMENSIONAL(3, Bbox3D.class);

    private int numberOfDimensions;
    private Class<? extends Bbox> bboxClass;

    public static Bbox toBbox(Double ... coordinates) {
        Validate.notEmpty(coordinates);
        int length = coordinates.length;
        int minCoordinates = 4;
        Validate.isTrue(length >= 4, "length: %s.", length);
        Dimensions dimensions = Arrays.stream(Dimensions.values()).filter(theseDimensions -> theseDimensions.getNumberOfCoordinates() == length).findFirst().orElseThrow(() -> new IllegalArgumentException(Arrays.toString((Object[])coordinates)));
        try {
            return ConstructorUtils.invokeConstructor(dimensions.getBboxClass(), (Object[])coordinates);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Dimensions(int numberOfDimensions, Class<? extends Bbox> bboxClass) {
        this.numberOfDimensions = numberOfDimensions;
        this.bboxClass = bboxClass;
    }

    public Class<? extends Bbox> getBboxClass() {
        return this.bboxClass;
    }

    public int getNumberOfCoordinates() {
        int multiply = 2;
        return this.getNumberOfDimensions() * 2;
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public void validate(Double ... coordinates) {
        Validate.notEmpty(coordinates, "coordinates is EMPTY for %s.", new Object[]{this});
        int actual = coordinates.length;
        int expected = this.getNumberOfCoordinates();
        Validate.isTrue(actual == expected, "coordinates.length actual {}; expected: {}.", actual, expected);
    }
}

