/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsCoordinateArrayConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsLinearRingConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class JtsPolygonToMultiPolygonConverter
implements TwoWayConverter<org.locationtech.jts.geom.Polygon, MultiPolygon> {
    private static final JtsLinearRingConverter LINEAR_RING_CONVERTER = new JtsLinearRingConverter();
    private static final GeometryFactory FACTORY = JtsPrecisionManager.getGeometryFactory();

    @Override
    public org.locationtech.jts.geom.Polygon backwardConvert(MultiPolygon object) {
        if (object.getOuterToInners().isEmpty()) {
            LinearRing[] emptyInners = new LinearRing[]{};
            return new org.locationtech.jts.geom.Polygon(JtsLinearRingConverter.empty(), emptyInners, FACTORY);
        }
        if (object.getOuterToInners().keySet().size() != 1) {
            throw new CoreException("A MultiPolygon can be converted to JTS Polygon only if it has no more than one outer ring.");
        }
        Polygon outer = object.outers().iterator().next();
        LinearRing linearRingOuter = LINEAR_RING_CONVERTER.convert(outer);
        Object inners = object.getOuterToInners().get(outer);
        LinearRing[] linearRingInners = new LinearRing[inners.size()];
        for (int index = 0; index < inners.size(); ++index) {
            linearRingInners[index] = LINEAR_RING_CONVERTER.convert((Polygon)inners.get(index));
        }
        return new org.locationtech.jts.geom.Polygon(linearRingOuter, linearRingInners, FACTORY);
    }

    @Override
    public MultiPolygon convert(org.locationtech.jts.geom.Polygon object) {
        MultiMap<Polygon, Polygon> outersToInners = new MultiMap<Polygon, Polygon>();
        List locationsOuter = (List)new JtsCoordinateArrayConverter().backwardConvert(object.getExteriorRing().getCoordinateSequence());
        Polygon outer = new Polygon(locationsOuter.subList(0, locationsOuter.size() - 1));
        outersToInners.put(outer, new ArrayList());
        for (int index = 0; index < object.getNumInteriorRing(); ++index) {
            List locationsInner = (List)new JtsCoordinateArrayConverter().backwardConvert(object.getInteriorRingN(index).getCoordinateSequence());
            Polygon inner = new Polygon(locationsInner.subList(0, locationsInner.size() - 1));
            outersToInners.add(outer, inner);
        }
        return new MultiPolygon(outersToInners);
    }
}

