/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.converters.jts.JtsLocationConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class JtsPointConverter
implements TwoWayConverter<Location, Point> {
    public static final GeometryFactory GEOMETRY_FACTORY = JtsPrecisionManager.getGeometryFactory();
    private static final JtsLocationConverter LOCATION_CONVERTER = new JtsLocationConverter();

    @Override
    public Location backwardConvert(Point point) {
        return new Location(Latitude.degrees(point.getY()), Longitude.degrees(point.getX()));
    }

    @Override
    public Point convert(Location location) {
        Coordinate coordinate = LOCATION_CONVERTER.convert(location);
        CoordinateArraySequence sequence = new CoordinateArraySequence(new Coordinate[]{coordinate});
        return new Point(sequence, GEOMETRY_FACTORY);
    }
}

