/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class JtsMultiPolygonToMultiPolygonConverter
implements TwoWayConverter<org.locationtech.jts.geom.MultiPolygon, MultiPolygon> {
    private static final JtsMultiPolygonConverter JTS_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonConverter();
    private static final GeometryFactory FACTORY = JtsPrecisionManager.getGeometryFactory();

    @Override
    public org.locationtech.jts.geom.MultiPolygon backwardConvert(MultiPolygon object) {
        Polygon[] polygons = JTS_MULTI_POLYGON_CONVERTER.convert(object).toArray(new Polygon[0]);
        return new org.locationtech.jts.geom.MultiPolygon(polygons, FACTORY);
    }

    @Override
    public MultiPolygon convert(org.locationtech.jts.geom.MultiPolygon object) {
        int numberGeometries = object.getNumGeometries();
        HashSet<Polygon> polygons = new HashSet<Polygon>();
        for (int index = 0; index < numberGeometries; ++index) {
            Polygon polygon = (Polygon)object.getGeometryN(index);
            polygons.add(polygon);
        }
        return JTS_MULTI_POLYGON_CONVERTER.backwardConvert((Set<Polygon>)polygons);
    }
}

