/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsLinearRingConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class JtsMultiPolygonConverter
implements TwoWayConverter<MultiPolygon, Set<org.locationtech.jts.geom.Polygon>> {
    private static final JtsLinearRingConverter LINEAR_RING_CONVERTER = new JtsLinearRingConverter();
    private static final JtsPolygonConverter POLYGON_CONVERTER = new JtsPolygonConverter();
    private static final GeometryFactory FACTORY = JtsPrecisionManager.getGeometryFactory();

    @Override
    public MultiPolygon backwardConvert(Set<org.locationtech.jts.geom.Polygon> object) {
        MultiMap<Polygon, Polygon> result = new MultiMap<Polygon, Polygon>();
        for (org.locationtech.jts.geom.Polygon polygon : object) {
            Polygon outer = POLYGON_CONVERTER.backwardConvert(polygon);
            if (outer == null) continue;
            for (int n = 0; n < polygon.getNumInteriorRing(); ++n) {
                LinearRing ring = new LinearRing(polygon.getInteriorRingN(n).getCoordinateSequence(), FACTORY);
                Polygon inner = LINEAR_RING_CONVERTER.backwardConvert(ring);
                result.add(outer, inner);
            }
            if (polygon.getNumInteriorRing() != 0) continue;
            result.put(outer, new ArrayList());
        }
        return new MultiPolygon(result);
    }

    @Override
    public Set<org.locationtech.jts.geom.Polygon> convert(MultiPolygon object) {
        HashSet<org.locationtech.jts.geom.Polygon> result = new HashSet<org.locationtech.jts.geom.Polygon>();
        for (Polygon outer : object.outers()) {
            List<Polygon> inners = object.innersOf(outer);
            LinearRing[] holes = new LinearRing[inners.size()];
            int index = 0;
            for (Polygon inner : inners) {
                holes[index++] = LINEAR_RING_CONVERTER.convert(inner);
            }
            result.add(new org.locationtech.jts.geom.Polygon(LINEAR_RING_CONVERTER.convert(outer), holes, FACTORY));
        }
        return result;
    }
}

