/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsCoordinateArrayConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPrecisionManager;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class JtsLinearRingConverter
implements TwoWayConverter<Polygon, LinearRing> {
    private static final JtsCoordinateArrayConverter COORDINATE_ARRAY_CONVERTER = new JtsCoordinateArrayConverter();
    private static final GeometryFactory FACTORY = JtsPrecisionManager.getGeometryFactory();
    private static final int MINIMUM_LINEAR_RING_SIZE = 4;

    public static LinearRing empty() {
        return new LinearRing(JtsCoordinateArrayConverter.empty(), FACTORY);
    }

    @Override
    public Polygon backwardConvert(LinearRing object) {
        CoordinateSequence sequence = object.getCoordinateSequence();
        if (sequence.size() <= 0) {
            return null;
        }
        Coordinate[] newArray = new Coordinate[sequence.size() - 1];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = sequence.getCoordinate(i);
        }
        return new Polygon(COORDINATE_ARRAY_CONVERTER.backwardConvert(new CoordinateArraySequence(newArray)));
    }

    @Override
    public LinearRing convert(Polygon object) {
        ArrayList<Location> locations = new ArrayList<Location>(object);
        locations.add((Location)locations.get(0));
        while (locations.size() < 4) {
            locations.add((Location)locations.get(0));
        }
        return new LinearRing(COORDINATE_ARRAY_CONVERTER.convert((Iterable<Location>)locations), FACTORY);
    }
}

