/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters.jts;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public final class GeometryStreamer {
    public static Iterable<Geometry> stream(GeometryCollection collection) {
        int size = collection.getNumGeometries();
        return Iterables.indexBasedIterable(size, index -> collection.getGeometryN((int)index));
    }

    public static Iterable<Polygon> streamPolygons(GeometryCollection collection) {
        return Iterables.translate(GeometryStreamer.stream(collection), geometry -> (Polygon)geometry);
    }

    private GeometryStreamer() {
    }
}

