/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.converters.WkMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WktMultiPolygonConverter
extends WkMultiPolygonConverter<String> {
    private static final TwoWayConverter<String, Geometry> CONVERTER = new TwoWayConverter<String, Geometry>(){

        @Override
        public String backwardConvert(Geometry geometry) {
            return new WKTWriter().write(geometry);
        }

        @Override
        public Geometry convert(String wkt) {
            try {
                return new WKTReader().read(wkt);
            }
            catch (ParseException e) {
                throw new CoreException("Unable to parse WKT");
            }
        }
    };

    @Override
    TwoWayConverter<String, Geometry> getGeometryConverter() {
        return CONVERTER;
    }
}

