/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbPolygonConverter
implements TwoWayConverter<Polygon, byte[]> {
    @Override
    public Polygon backwardConvert(byte[] wkb) {
        org.locationtech.jts.geom.Polygon geometry = null;
        WKBReader myReader = new WKBReader();
        try {
            geometry = (org.locationtech.jts.geom.Polygon)myReader.read(wkb);
        }
        catch (ClassCastException | ParseException e) {
            throw new CoreException("Cannot parse wkb : {}", WKBWriter.toHex(wkb));
        }
        return new JtsPolygonConverter().backwardConvert(geometry);
    }

    @Override
    public byte[] convert(Polygon polygon) {
        org.locationtech.jts.geom.Polygon geometry = new JtsPolygonConverter().convert(polygon);
        byte[] wkb = new WKBWriter().write(geometry);
        return wkb;
    }
}

