/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.converters.WkMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbMultiPolygonConverter
extends WkMultiPolygonConverter<byte[]> {
    private static final TwoWayConverter<byte[], Geometry> CONVERTER = new TwoWayConverter<byte[], Geometry>(){

        @Override
        public byte[] backwardConvert(Geometry geometry) {
            return new WKBWriter().write(geometry);
        }

        @Override
        public Geometry convert(byte[] kyte) {
            try {
                return new WKBReader().read(kyte);
            }
            catch (ParseException e) {
                throw new CoreException("Unable to parse WKB");
            }
        }
    };

    @Override
    TwoWayConverter<byte[], Geometry> getGeometryConverter() {
        return CONVERTER;
    }
}

