/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolyLine;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolyLineConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public class WkbMultiPolyLineConverter
implements TwoWayConverter<MultiPolyLine, byte[]> {
    private static final WKBReader WKB_READER = new WKBReader();

    @Override
    public MultiPolyLine backwardConvert(byte[] wkb) {
        MultiLineString geometry = null;
        try {
            geometry = (MultiLineString)WKB_READER.read(wkb);
        }
        catch (ClassCastException | ParseException e) {
            throw new CoreException("Cannot parse wkb : {}", WKBWriter.toHex(wkb));
        }
        return new JtsMultiPolyLineConverter().backwardConvert(geometry);
    }

    @Override
    public byte[] convert(MultiPolyLine multiPolyLine) {
        MultiLineString geometry = new JtsMultiPolyLineConverter().convert(multiPolyLine);
        return new WKBWriter().write(geometry);
    }
}

