/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.TwoWayConverter;

public abstract class WkMultiPolygonConverter<T>
implements TwoWayConverter<MultiPolygon, T> {
    private static final JtsPolygonToMultiPolygonConverter POLYGON_TO_MULTI_POLYGON_CONVERTER = new JtsPolygonToMultiPolygonConverter();
    private static final JtsMultiPolygonToMultiPolygonConverter MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonToMultiPolygonConverter();

    @Override
    public MultiPolygon backwardConvert(T wkt) {
        try {
            Geometry result = (Geometry)this.getGeometryConverter().convert(wkt);
            if (result instanceof Polygon) {
                Polygon jtsPolygon = (Polygon)result;
                return POLYGON_TO_MULTI_POLYGON_CONVERTER.convert(jtsPolygon);
            }
            if (result instanceof org.locationtech.jts.geom.MultiPolygon) {
                return MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.convert((org.locationtech.jts.geom.MultiPolygon)result);
            }
            throw new CoreException("Unknown type: {}", result.getClass().getCanonicalName());
        }
        catch (Exception e) {
            throw new CoreException("Cannot parse wkt : {}", wkt, e);
        }
    }

    @Override
    public T convert(MultiPolygon multiPolygon) {
        Geometry geometry = multiPolygon.outers().size() > 1 ? MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert(multiPolygon) : POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert(multiPolygon);
        return this.getGeometryConverter().backwardConvert(geometry);
    }

    abstract TwoWayConverter<T, Geometry> getGeometryConverter();
}

