/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.TwoWayStringConverter;

public class PolygonStringConverter
implements TwoWayStringConverter<Polygon> {
    @Override
    public String backwardConvert(Polygon object) {
        return object.toCompactString();
    }

    @Override
    public Polygon convert(String object) {
        StringList split = StringList.split(object, ":");
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String location : split) {
            locations.add(Location.forString(location));
        }
        return new Polygon((List<Location>)locations);
    }

    public Polygon convertLongitudeLatitude(String object) {
        StringList split = StringList.split(object, ":");
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String location : split) {
            locations.add(Location.forStringLongitudeLatitude(location));
        }
        return new Polygon((List<Location>)locations);
    }
}

