/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.conversion.Converter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class MultiplePolyLineToMultiPolygonConverter
implements Converter<Map<Relation.Ring, Iterable<PolyLine>>, MultiPolygon> {
    private static final MultiplePolyLineToPolygonsConverter MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER = new MultiplePolyLineToPolygonsConverter();

    private static List<Polygon> buildOuters(Iterable<PolyLine> outers) {
        ArrayList<Polygon> outerPolygons = new ArrayList<Polygon>();
        Iterables.stream(outers).filter(line -> line instanceof Polygon).forEach(polygon -> outerPolygons.add((Polygon)polygon));
        ArrayList<PolyLine> outerPolyLines = new ArrayList<PolyLine>();
        Iterables.stream(outers).filter(line -> !(line instanceof Polygon)).forEach(outerPolyLines::add);
        MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER.convert((Iterable<PolyLine>)outerPolyLines).forEach(outerPolygons::add);
        return outerPolygons;
    }

    private static MultiMap<Polygon, Polygon> buildOutersToInnersMap(List<Polygon> outers, Iterable<PolyLine> inners) {
        MultiMap<Polygon, Polygon> outersToInners = new MultiMap<Polygon, Polygon>();
        outers.forEach(outer -> outersToInners.put((Polygon)outer, new ArrayList()));
        ArrayList innerPolygons = new ArrayList();
        ArrayList<PolyLine> innerPolyLines = new ArrayList<PolyLine>();
        Iterables.stream(inners).filter(line -> line instanceof Polygon).forEach(polygon -> innerPolygons.add((Polygon)polygon));
        Iterables.stream(inners).filter(line -> !(line instanceof Polygon)).forEach(innerPolyLines::add);
        MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER.convert((Iterable<PolyLine>)innerPolyLines).forEach(innerPolygons::add);
        innerPolygons.forEach(inner -> {
            boolean added = false;
            for (Polygon outer : outersToInners.keySet()) {
                if (!outer.overlaps((PolyLine)inner) || inner.fullyGeometricallyEncloses(outer)) continue;
                outersToInners.add(outer, (Polygon)inner);
                added = true;
                break;
            }
            if (!added) {
                throw new CoreException("Malformed MultiPolygon: inner has no outer host: {}", inner);
            }
        });
        return outersToInners;
    }

    @Override
    public MultiPolygon convert(Map<Relation.Ring, Iterable<PolyLine>> outersAndInners) {
        List<Polygon> outers = MultiplePolyLineToMultiPolygonConverter.buildOuters(outersAndInners.get((Object)Relation.Ring.OUTER));
        if (outers.isEmpty()) {
            throw new CoreException("Unable to find outer polygon.");
        }
        MultiMap<Polygon, Polygon> outersToInners = MultiplePolyLineToMultiPolygonConverter.buildOutersToInnersMap(outers, outersAndInners.get((Object)Relation.Ring.INNER));
        return new MultiPolygon(outersToInners);
    }
}

