/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.clipping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsMultiPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public final class GeometryOperation {
    private static final JtsMultiPolygonToMultiPolygonConverter JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonToMultiPolygonConverter();
    private static final JtsMultiPolygonConverter JTS_MULTI_POLYGON_CONVERTER = new JtsMultiPolygonConverter();

    public static Optional<GeometricSurface> union(MultiPolygon ... multiPolygons) {
        return GeometryOperation.union(Iterables.asList(multiPolygons));
    }

    public static Optional<GeometricSurface> union(Iterable<MultiPolygon> multiPolygons) {
        ArrayList<Geometry> toUnion = new ArrayList<Geometry>();
        for (MultiPolygon multiPolygon : multiPolygons) {
            toUnion.add(JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.backwardConvert(multiPolygon));
        }
        try {
            return GeometryOperation.union(toUnion);
        }
        catch (Exception e) {
            throw new CoreException("Error computing union of {}!", Iterables.asList(multiPolygons));
        }
    }

    private static Optional<GeometricSurface> handleMultiPolygon(org.locationtech.jts.geom.MultiPolygon result) {
        return Optional.of(JTS_MULTI_POLYGON_TO_MULTI_POLYGON_CONVERTER.convert(result));
    }

    private static Optional<GeometricSurface> handlePolygon(Polygon result) {
        HashSet<Polygon> resultSet = new HashSet<Polygon>();
        resultSet.add(result);
        MultiPolygon resultMultiPolygon = JTS_MULTI_POLYGON_CONVERTER.backwardConvert((Set<Polygon>)resultSet);
        if (resultMultiPolygon.inners().isEmpty() && resultMultiPolygon.outers().size() == 1) {
            return Optional.of((GeometricSurface)resultMultiPolygon.outers().iterator().next());
        }
        return Optional.of(resultMultiPolygon);
    }

    private static Optional<GeometricSurface> union(List<Geometry> toUnion) {
        Geometry result = UnaryUnionOp.union(toUnion);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result instanceof org.locationtech.jts.geom.MultiPolygon) {
            return GeometryOperation.handleMultiPolygon((org.locationtech.jts.geom.MultiPolygon)result);
        }
        if (result instanceof Polygon) {
            return GeometryOperation.handlePolygon((Polygon)result);
        }
        throw new CoreException("Result is neither empty, MultiPolygon or Polygon");
    }

    private GeometryOperation() {
    }
}

