/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary.converters;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.utilities.conversion.Converter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryBoundaryMapGeoJsonConverter
implements Converter<CountryBoundaryMap, JsonObject> {
    private static final Logger logger = LoggerFactory.getLogger(CountryBoundaryMapGeoJsonConverter.class);
    private boolean usePolygons = false;
    private boolean prettyPrint = false;
    private Set<String> countryWhitelist = null;
    private Set<String> countryBlacklist = null;

    @Override
    public JsonObject convert(CountryBoundaryMap map) {
        MultiMap<String, org.locationtech.jts.geom.Polygon> countryNameToBoundaryMap = map.getCountryNameToBoundaryMap();
        JsonObject featureCollectionObject = new JsonObject();
        featureCollectionObject.addProperty("type", "FeatureCollection");
        JsonArray features = new JsonArray();
        for (Map.Entry<String, List<org.locationtech.jts.geom.Polygon>> entry : countryNameToBoundaryMap.entrySet()) {
            String countryCode = entry.getKey();
            List<org.locationtech.jts.geom.Polygon> polygons = entry.getValue();
            if (this.countryBlacklist != null && this.countryBlacklist.contains(countryCode) || this.countryWhitelist != null && !this.countryWhitelist.contains(countryCode)) continue;
            polygons.forEach(polygon -> {
                Polygon atlasPolygon;
                JsonObject featureObject = new JsonObject();
                featureObject.addProperty("type", "Feature");
                if (this.usePolygons) {
                    atlasPolygon = new JtsPolygonConverter().backwardConvert((org.locationtech.jts.geom.Polygon)polygon);
                    featureObject.add("geometry", atlasPolygon.asGeoJsonGeometry());
                } else {
                    atlasPolygon = new JtsPolygonConverter().backwardConvert((org.locationtech.jts.geom.Polygon)polygon);
                    featureObject.add("geometry", new PolyLine(atlasPolygon.closedLoop()).asGeoJsonGeometry());
                }
                JsonObject propertiesObject = new JsonObject();
                propertiesObject.addProperty("iso_country_code", countryCode);
                featureObject.add("properties", propertiesObject);
                features.add(featureObject);
            });
            logger.trace("Finished processing polygons for {}", (Object)countryCode);
        }
        featureCollectionObject.add("features", features);
        return featureCollectionObject;
    }

    public String convertToString(CountryBoundaryMap map) {
        if (this.prettyPrint) {
            return new GsonBuilder().setPrettyPrinting().create().toJson(this.convert(map));
        }
        return this.convert(map).toString();
    }

    public CountryBoundaryMapGeoJsonConverter prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public CountryBoundaryMapGeoJsonConverter usePolygons(boolean usePolygons) {
        this.usePolygons = usePolygons;
        return this;
    }

    public CountryBoundaryMapGeoJsonConverter withCountryBlacklist(Set<String> countryBlacklist) {
        this.countryBlacklist = countryBlacklist;
        return this;
    }

    public CountryBoundaryMapGeoJsonConverter withCountryWhitelist(Set<String> countryWhitelist) {
        this.countryWhitelist = countryWhitelist;
        return this;
    }
}

