/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.strtree.STRtree;
import org.openstreetmap.atlas.geography.boundary.AbstractGridIndexBuilder;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicGridIndexBuilder
extends AbstractGridIndexBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DynamicGridIndexBuilder.class);
    private static final double BOUND_ROUNDING_IN_MICRODEGREES = 0.0;
    private static final double GRANULARITY = 0.02;
    private volatile STRtree index;
    private STRtree rawIndex;
    private final List<Polygon> boundaries;
    private final Envelope envelope;

    public DynamicGridIndexBuilder(List<Polygon> boundaries, Envelope envelope, STRtree rawIndex) {
        this.envelope = envelope;
        this.boundaries = boundaries;
        this.index = null;
        this.rawIndex = rawIndex;
        if (this.rawIndex == null) {
            this.createRawIndex();
        }
    }

    @Override
    public List<Polygon> getBoundaries() {
        return this.boundaries;
    }

    @Override
    public Envelope getEnvelope() {
        return this.envelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRtree getIndex() {
        STRtree localIndex = this.index;
        if (localIndex == null) {
            DynamicGridIndexBuilder dynamicGridIndexBuilder = this;
            synchronized (dynamicGridIndexBuilder) {
                localIndex = this.index;
                if (localIndex == null) {
                    this.index = new STRtree();
                    LinkedBlockingQueue queue = new LinkedBlockingQueue();
                    ((Stream)this.boundaries.stream().parallel()).forEach(boundary -> {
                        Envelope bound;
                        Envelope workingBound = bound = boundary.getEnvelopeInternal();
                        if (this.envelope != null) {
                            workingBound = bound.intersection(this.envelope);
                        }
                        workingBound.expandBy(0.0);
                        queue.add(new GridWorkItem(workingBound.getMinX(), workingBound.getMinY(), workingBound.getMaxX(), workingBound.getMaxY(), (Polygon)boundary));
                    });
                    int threadCount = Runtime.getRuntime().availableProcessors() - 1;
                    logger.info("Building index with {} processors (threads).", (Object)threadCount);
                    try (Pool processPool = new Pool(threadCount, "Grid Index Builder");){
                        IntStream.range(0, threadCount).forEach(index -> processPool.queue(new Processor(queue, this.index, this.rawIndex)));
                    }
                    catch (Exception e) {
                        logger.error("Generating grid index is failed.", (Throwable)e);
                    }
                }
            }
        }
        return this.index;
    }

    private void createRawIndex() {
        this.rawIndex = new STRtree();
        for (Polygon boundary : this.boundaries) {
            this.rawIndex.insert(boundary.getEnvelopeInternal(), (Object)boundary);
        }
    }

    private class Processor
    implements Runnable {
        private final BlockingQueue<GridWorkItem> queue;
        private final STRtree index;
        private final STRtree rawIndex;

        Processor(BlockingQueue<GridWorkItem> queue, STRtree index, STRtree rawIndex) {
            this.queue = queue;
            this.index = index;
            this.rawIndex = rawIndex;
        }

        @Override
        public void run() {
            try {
                while (!this.queue.isEmpty()) {
                    GridWorkItem itemToProcess = (GridWorkItem)this.queue.poll();
                    if (itemToProcess == null) continue;
                    this.process(itemToProcess);
                }
            }
            catch (Exception e) {
                logger.error("Processor failed to process.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(GridWorkItem item) {
            double minX = item.minX;
            double minY = item.minY;
            double maxX = item.maxX;
            double maxY = item.maxY;
            Polygon polygon = item.polygon;
            Envelope box = null;
            try {
                box = new Envelope(minX, maxX, minY, maxY);
                double width = maxX - minX;
                double height = maxY - minY;
                Polygon geoBox = AbstractGridIndexBuilder.buildGeoBox(minX, maxX, minY, maxY);
                if (!geoBox.intersects(polygon)) {
                    return;
                }
                if (Math.max(width / 2.0, height / 2.0) < 0.02) {
                    STRtree sTRtree = this.index;
                    synchronized (sTRtree) {
                        this.index.insert(box, (Object)polygon);
                    }
                    return;
                }
                if (CountryBoundaryMap.isSameCountry(this.rawIndex.query(box)) || polygon.covers(geoBox)) {
                    STRtree sTRtree = this.index;
                    synchronized (sTRtree) {
                        this.index.insert(box, (Object)polygon);
                    }
                    return;
                }
                if (width > height) {
                    this.queue.add(new GridWorkItem(minX, minY, minX + width / 2.0, maxY, polygon));
                    this.queue.add(new GridWorkItem(minX + width / 2.0, minY, maxX, maxY, polygon));
                } else {
                    this.queue.add(new GridWorkItem(minX, minY, maxX, minY + height / 2.0, polygon));
                    this.queue.add(new GridWorkItem(minX, minY + height / 2.0, maxX, maxY, polygon));
                }
            }
            catch (TopologyException e) {
                String countryCode = CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code");
                logger.error("Unable to build tree under box {} for country code {}.", new Object[]{box, countryCode, e});
                STRtree sTRtree = this.index;
                synchronized (sTRtree) {
                    this.index.insert(box, (Object)polygon);
                }
            }
        }
    }

    private class GridWorkItem {
        private final double minX;
        private final double minY;
        private final double maxX;
        private final double maxY;
        private final Polygon polygon;

        GridWorkItem(double minX, double minY, double maxX, double maxY, Polygon polygon) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
            this.polygon = polygon;
        }
    }
}

