/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryShardListing;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.converters.StringToShardConverter;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CountryToShardListCache
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(CountryToShardListCache.class);
    private static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The country boundaries.", value -> CountryToShardListCache.initializeCountryBoundaryMap(value), Command.Optionality.REQUIRED);
    private static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "CSV list of the country iso3 codes", value -> StringList.split(value, ","), Command.Optionality.OPTIONAL);
    private static final Command.Switch<Sharding> SHARDING = new Command.Switch("sharding", "File containing the sharding definition (Works with files only)", Sharding::forString, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The output file", File::new, Command.Optionality.REQUIRED);
    private static final String DELIMITER = "||";
    private static final StringToShardConverter CONVERTER = new StringToShardConverter();
    private final MultiMap<String, Shard> countryToShards = new MultiMap();

    public static void main(String[] args) {
        new CountryToShardListCache().run(args);
    }

    private static CountryBoundaryMap initializeCountryBoundaryMap(String value) {
        Time start = Time.now();
        logger.info("Loading boundaries");
        CountryBoundaryMap result = CountryBoundaryMap.fromPlainText(new File(value));
        logger.info("Loaded boundaries in {}", (Object)start.elapsedSince());
        return result;
    }

    public CountryToShardListCache(CountryBoundaryMap boundaries, Sharding sharding) {
        this(boundaries, new StringList(boundaries.allCountryNames()), sharding);
    }

    public CountryToShardListCache(CountryBoundaryMap boundaries, StringList countries, Sharding sharding) {
        CountryShardListing.countryToShardList(countries, boundaries, sharding).forEach((country, shardSet) -> shardSet.forEach(shard -> this.countryToShards.add((String)country, CONVERTER.convert(shard.getName()))));
    }

    public CountryToShardListCache(Resource resource) {
        try {
            resource.lines().forEach(line -> {
                String[] countryAndShardList = line.split(Pattern.quote(DELIMITER));
                String country = countryAndShardList[0];
                String shardList = countryAndShardList[1];
                Arrays.asList(shardList.split("\\s*,\\s*")).stream().map(CONVERTER::convert).forEach(shard -> this.countryToShards.add(country, (Shard)shard));
            });
        }
        catch (Exception e) {
            throw new CoreException("Error while reading CountryToShardListCache resource", e);
        }
    }

    private CountryToShardListCache() {
    }

    public List<Shard> getShardsForCountry(String country) {
        return this.countryToShards.getOrDefault(country, (Shard)((Object)Collections.emptyList()));
    }

    public void save(WritableResource output) {
        try (SafeBufferedWriter writer = output.writer();){
            this.countryToShards.forEach((country, shardList) -> {
                List shardNames = shardList.stream().map(slippyTile -> slippyTile.getName()).collect(Collectors.toList());
                writer.writeLine(String.format("%s%s%s", country, DELIMITER, shardNames).replace("[", "").replace("]", ""));
            });
        }
        catch (Exception e) {
            throw new CoreException("Error while writing CountryToShardListCache to file!", e);
        }
    }

    @Override
    protected int onRun(CommandMap command) {
        StringList countries = (StringList)command.get(COUNTRIES);
        CountryBoundaryMap boundaries = (CountryBoundaryMap)command.get(BOUNDARIES);
        File output = (File)command.get(OUTPUT);
        Sharding sharding = (Sharding)command.get(SHARDING);
        CountryToShardListCache cache = null;
        cache = countries != null ? new CountryToShardListCache(boundaries, countries, sharding) : new CountryToShardListCache(boundaries, sharding);
        logger.info("Saving file to {}", (Object)output);
        cache.save(output);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(COUNTRIES, BOUNDARIES, OUTPUT, SHARDING);
    }
}

