/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.boundary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.clipping.Clip;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class CountryBoundaryMapFiller
extends Command {
    public static final Command.Switch<File> INPUT = new Command.Switch("input", "The input boundary file", File::new, Command.Optionality.REQUIRED);
    public static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The output boundary file", File::new, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new CountryBoundaryMapFiller().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        File input = (File)command.get(INPUT);
        File output = (File)command.get(OUTPUT);
        CountryBoundaryMap map = CountryBoundaryMap.fromPlainText(input);
        MultiMap<Polygon, Polygon> outerToInners = new MultiMap<Polygon, Polygon>();
        HashMap<String, MultiPolygon> resultMap = new HashMap<String, MultiPolygon>();
        map.allCountryNames().stream().map(country -> new Tuple<String, MultiPolygon>((String)country, map.countryBoundary((String)country).iterator().next().getBoundary())).forEach(tuple -> {
            String countryName = (String)tuple.getFirst();
            MultiPolygon multiPolygon = (MultiPolygon)tuple.getSecond();
            resultMap.put(countryName, multiPolygon);
            for (Polygon outer : multiPolygon.outers()) {
                outerToInners.put(outer, new ArrayList());
                for (Polygon inner : multiPolygon.innersOf(outer)) {
                    outerToInners.add(outer, inner);
                }
            }
        });
        MultiPolygon allCountries = new MultiPolygon(outerToInners);
        Clip clip = MultiPolygon.forPolygon(Rectangle.MAXIMUM).clip(allCountries, Clip.ClipType.NOT);
        MultiPolygon result = clip.getClipMultiPolygon();
        resultMap.put("N/A", result);
        try {
            CountryBoundaryMap.fromBoundaryMap(resultMap).writeToFile(output);
        }
        catch (IOException e) {
            throw new CoreException("Could not write new boundaries file to {}", output, e);
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT, OUTPUT);
    }
}

