/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.validators;

import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.validators.AtlasEdgeValidator;
import org.openstreetmap.atlas.geography.atlas.validators.AtlasLineItemValidator;
import org.openstreetmap.atlas.geography.atlas.validators.AtlasLocationItemValidator;
import org.openstreetmap.atlas.geography.atlas.validators.AtlasNodeValidator;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasValidator {
    private static final Logger logger = LoggerFactory.getLogger(AtlasValidator.class);
    private final Atlas atlas;

    public AtlasValidator(Atlas atlas) {
        this.atlas = atlas;
    }

    public void validate() {
        logger.info("Starting validation of Atlas {}", (Object)this.atlas.getName());
        Time start = Time.now();
        logger.trace("Starting relation validation of Atlas {}", (Object)this.atlas.getName());
        Time startRelations = Time.now();
        this.validateRelationsPresentAndLinked();
        logger.trace("Finished relation validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)startRelations.elapsedSince());
        logger.trace("Starting tags validation of Atlas {}", (Object)this.atlas.getName());
        Time startTags = Time.now();
        this.validateTagsPresent();
        logger.trace("Finished tags validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)startTags.elapsedSince());
        new AtlasLocationItemValidator(this.atlas).validate();
        new AtlasLineItemValidator(this.atlas).validate();
        new AtlasEdgeValidator(this.atlas).validate();
        new AtlasNodeValidator(this.atlas).validate();
        logger.info("Finished validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)start.elapsedSince());
    }

    protected void validateRelationsPresentAndLinked() {
        for (AtlasEntity entity : this.atlas.entities()) {
            for (Relation relation : entity.relations()) {
                if (relation == null) {
                    throw new CoreException("Entity {} {} lists some parent relation that is not present: {}", new Object[]{entity.getType(), entity.getIdentifier(), entity.relations().stream().map(parent -> parent == null ? "null" : String.valueOf(parent.getIdentifier())).collect(Collectors.toSet())});
                }
                if (relation.members().asBean().getItemFor(entity.getIdentifier(), entity.getType()).isPresent()) continue;
                throw new CoreException("Entity {} {} lists parent relation {} which does not have it as a member.", new Object[]{entity.getType(), entity.getIdentifier(), relation.getIdentifier()});
            }
        }
    }

    protected void validateTagsPresent() {
        for (AtlasEntity entity : this.atlas.entities()) {
            Map<String, String> tags = entity.getTags();
            if (tags != null) continue;
            throw new CoreException("Entity {} {} is missing tags.", new Object[]{entity.getType(), entity.getIdentifier()});
        }
    }
}

