/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.validators;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasLineItemValidator {
    private static final Logger logger = LoggerFactory.getLogger(AtlasLineItemValidator.class);
    private final Atlas atlas;

    public AtlasLineItemValidator(Atlas atlas) {
        this.atlas = atlas;
    }

    public void validate() {
        logger.trace("Starting LineItem validation of Atlas {}", (Object)this.atlas.getName());
        Time start = Time.now();
        this.validatePolyLinePresent();
        logger.trace("Finished LineItem validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)start.elapsedSince());
    }

    private void validatePolyLinePresent() {
        for (LineItem lineItem : this.atlas.lineItems()) {
            if (lineItem.asPolyLine() != null) continue;
            throw new CoreException("{} {} is missing its PolyLine.", new Object[]{lineItem.getType(), lineItem.getIdentifier()});
        }
    }
}

