/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.validators;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEdgeValidator {
    private static final Logger logger = LoggerFactory.getLogger(AtlasEdgeValidator.class);
    private final Atlas atlas;

    public AtlasEdgeValidator(Atlas atlas) {
        this.atlas = atlas;
    }

    public void validate() {
        logger.trace("Starting Edge validation of Atlas {}", (Object)this.atlas.getName());
        Time start = Time.now();
        this.validateEdgeToNodeConnectivity();
        this.validateEdgeToNodeLocationAccuracy();
        this.validateReverseEdgePolyLineUpdated();
        logger.trace("Finished Edge validation of Atlas {} in {}", (Object)this.atlas.getName(), (Object)start.elapsedSince());
    }

    protected void validateEdgeToNodeConnectivity() {
        for (Edge edge : this.atlas.edges()) {
            Node start = edge.start();
            if (start == null) {
                throw new CoreException("Edge {} is logically disconnected at its start. Referenced Node does not exist.", edge.getIdentifier());
            }
            if (start.outEdges().stream().noneMatch(edgeAtNode -> edgeAtNode.getIdentifier() == edge.getIdentifier())) {
                throw new CoreException("Edge {} references start Node {}. It is not reciprocal.", edge.getIdentifier(), start.getIdentifier());
            }
            Node end = edge.end();
            if (end == null) {
                throw new CoreException("Edge {} is logically disconnected at its end. Referenced Node does not exist.", edge.getIdentifier());
            }
            if (!end.inEdges().stream().noneMatch(edgeAtNode -> edgeAtNode.getIdentifier() == edge.getIdentifier())) continue;
            throw new CoreException("Edge {} references end Node {}. It is not reciprocal.", edge.getIdentifier(), end.getIdentifier());
        }
    }

    protected void validateEdgeToNodeLocationAccuracy() {
        for (Edge edge : this.atlas.edges()) {
            Location edgeEndLocation;
            Location edgeStartLocation;
            Location startNodeLocation = edge.start().getLocation();
            if (!startNodeLocation.equals(edgeStartLocation = edge.asPolyLine().first())) {
                throw new CoreException("Edge {} with start location {} does not match with its start Node {} at location: {}", edge.getIdentifier(), edgeStartLocation, edge.start().getIdentifier(), startNodeLocation);
            }
            Location endNodeLocation = edge.end().getLocation();
            if (endNodeLocation.equals(edgeEndLocation = edge.asPolyLine().last())) continue;
            throw new CoreException("Edge {} with end location {} does not match with its end Node {} at location: {}", edge.getIdentifier(), edgeEndLocation, edge.end().getIdentifier(), endNodeLocation);
        }
    }

    protected void validateReverseEdgePolyLineUpdated() {
        for (Edge edge2 : this.atlas.edges(edge -> edge.hasReverseEdge() && edge.isMasterEdge())) {
            PolyLine backward;
            Edge reversed = edge2.reversed().orElseThrow(() -> new CoreException("Edge {} should have a reverse, but does not.", edge2.getIdentifier()));
            PolyLine forward = edge2.asPolyLine();
            if (forward.equals((backward = reversed.asPolyLine()).reversed())) continue;
            throw new CoreException("Edge {} and its reverse {} have mismatching PolyLines: Forward = {}, Backward = {}", edge2.getIdentifier(), reversed.getIdentifier(), forward, backward);
        }
    }
}

