/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.sub;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubAtlasCreator {
    private static final Logger logger = LoggerFactory.getLogger(SubAtlasCreator.class);
    private static final String CUT_START_MESSAGE = "Starting {} of Atlas {} with meta-data {}";
    private static final String CUT_STOP_MESSAGE = "Finished {} of Atlas {} in {}";
    private static final String SUB_ATLAS_NAME_POSTFIX = "_sub";
    private static final double HARD_CUT_RATIO_BUFFER = 0.5;
    private static final double SOFT_CUT_RATIO_BUFFER = 1.2;

    public static Optional<Atlas> hardCutAllEntities(Atlas atlas, GeometricSurface boundary) {
        logger.debug(CUT_START_MESSAGE, new Object[]{AtlasCutType.HARD_CUT_ALL, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        Iterable<Node> nodesWithin = SubAtlasCreator.getContainmentCachingSupplier(atlas, atlas.nodesWithin(boundary), ItemType.NODE).get();
        Iterable<Edge> edgesWithin = SubAtlasCreator.getContainmentCachingSupplier(atlas, atlas.edgesWithin(boundary), ItemType.EDGE).get();
        Iterable<Area> areasWithin = SubAtlasCreator.getContainmentCachingSupplier(atlas, atlas.areasWithin(boundary), ItemType.AREA).get();
        Iterable<Line> linesWithin = SubAtlasCreator.getContainmentCachingSupplier(atlas, atlas.linesWithin(boundary), ItemType.LINE).get();
        Iterable<Point> pointsWithin = SubAtlasCreator.getContainmentCachingSupplier(atlas, atlas.pointsWithin(boundary), ItemType.POINT).get();
        long nodeEstimate = Math.round((double)Iterables.size(nodesWithin) * 0.5);
        AtlasSize sizeEstimates = new AtlasSize(Iterables.size(edgesWithin), nodeEstimate, Iterables.size(areasWithin), Iterables.size(linesWithin), Iterables.size(pointsWithin), Iterables.size(atlas.relationsWithEntitiesIntersecting(boundary)));
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, sizeEstimates);
        SubAtlasCreator.addNodes(nodesWithin, node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addEdges(edgesWithin, edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addAreas(areasWithin, builder);
        SubAtlasCreator.addLines(linesWithin, builder);
        SubAtlasCreator.addPoints(pointsWithin, builder);
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), relation -> !SubAtlasCreator.hasEntity(relation, builder), member -> SubAtlasCreator.hasEntity(member.getEntity(), builder), builder, AtlasCutType.HARD_CUT_ALL);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{AtlasCutType.HARD_CUT_ALL, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    public static Optional<Atlas> hardCutAllEntities(Atlas atlas, Predicate<AtlasEntity> matcher) {
        logger.debug(CUT_START_MESSAGE, new Object[]{AtlasCutType.HARD_CUT_ALL, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, atlas.size());
        Set<Long> matchedEdgeIdentifiers = Iterables.stream(atlas.edges(matcher::test)).map(AtlasObject::getIdentifier).collectToSet();
        Predicate<Node> validNodeFilter = node -> !SubAtlasCreator.hasEntity(node, builder) && node.connectedEdges().stream().anyMatch(connectedEdge -> matchedEdgeIdentifiers.contains(connectedEdge.getIdentifier()));
        SubAtlasCreator.addNodes(atlas.nodes(matcher::test), validNodeFilter, builder);
        Predicate<Edge> validEdgeFilter = edge -> !SubAtlasCreator.hasEntity(edge, builder) && builder.peek().node(edge.start().getIdentifier()) != null && builder.peek().node(edge.end().getIdentifier()) != null;
        SubAtlasCreator.addEdges(atlas.edges(matcher::test), validEdgeFilter, builder);
        SubAtlasCreator.addPoints(atlas.points(matcher::test), builder);
        SubAtlasCreator.addAreas(atlas.areas(matcher::test), builder);
        SubAtlasCreator.addLines(atlas.lines(matcher::test), builder);
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), matcher::test, member -> SubAtlasCreator.hasEntity(member.getEntity(), builder), builder, AtlasCutType.HARD_CUT_ALL);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{AtlasCutType.HARD_CUT_ALL, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    public static Optional<Atlas> hardCutRelationsOnly(Atlas atlas, Predicate<AtlasEntity> matcher) {
        logger.debug(CUT_START_MESSAGE, new Object[]{AtlasCutType.HARD_CUT_RELATIONS_ONLY, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, atlas.size());
        SubAtlasCreator.addNodes(atlas.nodes(matcher::test), node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addNodesFromEdges(atlas.edges(matcher::test), builder);
        SubAtlasCreator.addEdges(atlas.edges(matcher::test), edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addPoints(atlas.points(matcher::test), builder);
        SubAtlasCreator.addAreas(atlas.areas(matcher::test), builder);
        SubAtlasCreator.addLines(atlas.lines(matcher::test), builder);
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), matcher::test, member -> SubAtlasCreator.hasEntity(member.getEntity(), builder), builder, AtlasCutType.HARD_CUT_RELATIONS_ONLY);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{AtlasCutType.HARD_CUT_RELATIONS_ONLY, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    public static Optional<Atlas> silkCut(Atlas atlas, GeometricSurface boundary) {
        logger.debug(CUT_START_MESSAGE, new Object[]{AtlasCutType.SILK_CUT, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        Iterable<Node> nodesWithin = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.nodesWithin(boundary), ItemType.NODE).get();
        Iterable<Edge> edgesIntersecting = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.edgesIntersecting(boundary), ItemType.EDGE).get();
        Iterable<Area> areasIntersecting = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.areasIntersecting(boundary), ItemType.AREA).get();
        Iterable<Line> linesIntersecting = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.linesIntersecting(boundary), ItemType.LINE).get();
        Iterable<Point> pointsWithin = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.pointsWithin(boundary), ItemType.POINT).get();
        long nodeNumber = Math.round((double)Iterables.size(nodesWithin) * 1.2);
        long edgeNumber = Math.round((double)Iterables.size(edgesIntersecting) * 1.2);
        long areaNumber = Math.round((double)Iterables.size(areasIntersecting) * 1.2);
        long lineNumber = Math.round((double)Iterables.size(linesIntersecting) * 1.2);
        long pointNumber = Math.round((double)Iterables.size(pointsWithin) * 1.2);
        long relationNumber = Math.round((double)Iterables.size(atlas.relationsWithEntitiesIntersecting(boundary)) * 1.2);
        AtlasSize sizeEstimates = new AtlasSize(edgeNumber, nodeNumber, areaNumber, lineNumber, pointNumber, relationNumber);
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, sizeEstimates);
        SubAtlasCreator.addNodes(nodesWithin, node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addNodesFromEdges(edgesIntersecting, builder);
        SubAtlasCreator.addEdges(edgesIntersecting, edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addAreas(areasIntersecting, builder);
        SubAtlasCreator.addLines(linesIntersecting, builder);
        SubAtlasCreator.addPoints(pointsWithin, builder);
        SubAtlasCreator.addPointsForLines(atlas, linesIntersecting, builder);
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), relation -> !SubAtlasCreator.hasEntity(relation, builder), member -> SubAtlasCreator.hasEntity(member.getEntity(), builder), builder, AtlasCutType.SILK_CUT);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{AtlasCutType.SILK_CUT, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    public static Optional<Atlas> silkCut(Atlas atlas, Predicate<AtlasEntity> matcher) {
        logger.debug(CUT_START_MESSAGE, new Object[]{AtlasCutType.SOFT_CUT, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, atlas.size());
        atlas.relations(matcher::test).forEach(relation -> SubAtlasCreator.addNodesFromRelation(relation, builder));
        SubAtlasCreator.addNodes(atlas.nodes(matcher::test), node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addNodesFromEdges(atlas.edges(matcher::test), builder);
        SubAtlasCreator.addEdges(atlas.edges(matcher::test), edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addPoints(atlas.points(matcher::test), builder);
        SubAtlasCreator.addAreas(atlas.areas(matcher::test), builder);
        SubAtlasCreator.addLines(atlas.lines(matcher::test), builder);
        SubAtlasCreator.addPointsForLines(atlas, atlas.lines(matcher::test), builder);
        Iterables.filter(atlas.relationsLowerOrderFirst(), matcher::test).forEach(relation -> SubAtlasCreator.addRelationMembers(relation, builder));
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), matcher::test, member -> true, builder, AtlasCutType.SOFT_CUT);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{AtlasCutType.SOFT_CUT, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    public static Optional<Atlas> softCut(Atlas atlas, GeometricSurface boundary, boolean hardCutRelations) {
        logger.debug(CUT_START_MESSAGE, new Object[]{!hardCutRelations ? AtlasCutType.SOFT_CUT : AtlasCutType.HARD_CUT_RELATIONS_ONLY, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        Iterable<Node> nodesWithin = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.nodesWithin(boundary), ItemType.NODE).get();
        Iterable<Edge> edgesIntersecting = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.edgesIntersecting(boundary), ItemType.EDGE).get();
        Iterable<Area> areasIntersecting = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.areasIntersecting(boundary), ItemType.AREA).get();
        Iterable<Line> linesIntersecting = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.linesIntersecting(boundary), ItemType.LINE).get();
        Iterable<Point> pointsWithin = SubAtlasCreator.getIntersectingCachingSupplier(atlas, atlas.pointsWithin(boundary), ItemType.POINT).get();
        long nodeNumber = Math.round((double)Iterables.size(nodesWithin) * 1.2);
        long edgeNumber = Math.round((double)Iterables.size(edgesIntersecting) * 1.2);
        long areaNumber = Math.round((double)Iterables.size(areasIntersecting) * 1.2);
        long lineNumber = Math.round((double)Iterables.size(linesIntersecting) * 1.2);
        long pointNumber = Math.round((double)Iterables.size(pointsWithin) * 1.2);
        long relationNumber = Math.round((double)Iterables.size(atlas.relationsWithEntitiesIntersecting(boundary)) * 1.2);
        AtlasSize sizeEstimates = new AtlasSize(edgeNumber, nodeNumber, areaNumber, lineNumber, pointNumber, relationNumber);
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, sizeEstimates);
        SubAtlasCreator.addNodes(nodesWithin, node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addNodesFromEdges(edgesIntersecting, builder);
        SubAtlasCreator.addEdges(edgesIntersecting, edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addAreas(areasIntersecting, builder);
        SubAtlasCreator.addLines(linesIntersecting, builder);
        SubAtlasCreator.addPoints(pointsWithin, builder);
        Predicate<RelationMember> validMemberTest = hardCutRelations ? member -> {
            switch (member.getEntity().getType()) {
                case POINT: 
                case NODE: {
                    return boundary.fullyGeometricallyEncloses(((LocationItem)member.getEntity()).getLocation());
                }
                case EDGE: 
                case LINE: {
                    return boundary.fullyGeometricallyEncloses(((LineItem)member.getEntity()).asPolyLine());
                }
                case AREA: {
                    return boundary.fullyGeometricallyEncloses(((Area)member.getEntity()).asPolygon());
                }
                case RELATION: {
                    return SubAtlasCreator.hasEntity(member.getEntity(), builder);
                }
            }
            return false;
        } : member -> SubAtlasCreator.hasEntity(member.getEntity(), builder);
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), relation -> !SubAtlasCreator.hasEntity(relation, builder), validMemberTest, builder, AtlasCutType.SOFT_CUT);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{!hardCutRelations ? AtlasCutType.SOFT_CUT : AtlasCutType.HARD_CUT_RELATIONS_ONLY, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    public static Optional<Atlas> softCut(Atlas atlas, Predicate<AtlasEntity> matcher) {
        logger.debug(CUT_START_MESSAGE, new Object[]{AtlasCutType.SOFT_CUT, atlas.getName(), atlas.metaData()});
        Time begin = Time.now();
        PackedAtlasBuilder builder = SubAtlasCreator.getPackedAtlasBuilder(atlas, atlas.size());
        atlas.relations(matcher::test).forEach(relation -> SubAtlasCreator.addNodesFromRelation(relation, builder));
        SubAtlasCreator.addNodes(atlas.nodes(matcher::test), node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addNodesFromEdges(atlas.edges(matcher::test), builder);
        SubAtlasCreator.addEdges(atlas.edges(matcher::test), edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addPoints(atlas.points(matcher::test), builder);
        SubAtlasCreator.addAreas(atlas.areas(matcher::test), builder);
        SubAtlasCreator.addLines(atlas.lines(matcher::test), builder);
        Iterables.filter(atlas.relationsLowerOrderFirst(), matcher::test).forEach(relation -> SubAtlasCreator.addRelationMembers(relation, builder));
        SubAtlasCreator.addRelations(atlas, atlas.relationsLowerOrderFirst(), matcher::test, member -> true, builder, AtlasCutType.SOFT_CUT);
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info(CUT_STOP_MESSAGE, new Object[]{AtlasCutType.SOFT_CUT, atlas.getName(), begin.elapsedSince()});
        return Optional.ofNullable(result);
    }

    private static void addAllSubRelations(Atlas atlas, Relation parentRelation, PackedAtlasBuilder builder) {
        Set<Long> subrelations = parentRelation.flattenRelations();
        for (Relation relation : atlas.relationsLowerOrderFirst()) {
            Long relationId = relation.getIdentifier();
            if (subrelations.contains(relationId) && !SubAtlasCreator.hasEntity(relation, builder)) {
                builder.addRelation(relationId, relation.getOsmIdentifier(), relation.getBean(), relation.getTags());
            }
            if (relationId.longValue() != parentRelation.getIdentifier()) continue;
            return;
        }
    }

    private static void addAreas(Iterable<Area> areas, PackedAtlasBuilder builder) {
        areas.forEach(area -> builder.addArea(area.getIdentifier(), area.asPolygon(), area.getTags()));
    }

    private static void addEdges(Iterable<Edge> edges, Predicate<Edge> validEdges, PackedAtlasBuilder builder) {
        Consumer<Edge> edgeAdder = edge -> {
            Edge reverse;
            if (edge.getIdentifier() != 0L && edge.hasReverseEdge() && !SubAtlasCreator.hasEntity(reverse = edge.reversed().get(), builder)) {
                builder.addEdge(reverse.getIdentifier(), reverse.asPolyLine(), reverse.getTags());
            }
            builder.addEdge(edge.getIdentifier(), edge.asPolyLine(), edge.getTags());
        };
        Iterables.stream(edges).filter(validEdges).forEach(edgeAdder::accept);
    }

    private static void addLines(Iterable<Line> lines, PackedAtlasBuilder builder) {
        lines.forEach(line -> builder.addLine(line.getIdentifier(), line.asPolyLine(), line.getTags()));
    }

    private static void addNodes(Iterable<Node> nodes, Predicate<Node> validNodeFilter, PackedAtlasBuilder builder) {
        Iterables.stream(nodes).filter(validNodeFilter).forEach(node -> builder.addNode(node.getIdentifier(), node.getLocation(), node.getTags()));
    }

    private static void addNodesFromEdges(Iterable<Edge> edges, PackedAtlasBuilder builder) {
        edges.forEach(edge -> {
            Node start = edge.start();
            Node end = edge.end();
            if (!SubAtlasCreator.hasEntity(start, builder)) {
                builder.addNode(start.getIdentifier(), start.getLocation(), start.getTags());
            }
            if (!SubAtlasCreator.hasEntity(end, builder)) {
                builder.addNode(end.getIdentifier(), end.getLocation(), end.getTags());
            }
        });
    }

    private static void addNodesFromRelation(Relation relation, PackedAtlasBuilder builder) {
        Set<AtlasObject> relationMembers = relation.flatten();
        Set<Edge> edgeMembers = relationMembers.stream().filter(member -> member instanceof Edge).collect(Collectors.toSet());
        Set<Node> nodeMembers = relationMembers.stream().filter(member -> member instanceof Node).collect(Collectors.toSet());
        SubAtlasCreator.addNodes(nodeMembers, node -> !SubAtlasCreator.hasEntity(node, builder), builder);
        SubAtlasCreator.addNodesFromEdges(edgeMembers, builder);
    }

    private static void addPoints(Iterable<Point> points, PackedAtlasBuilder builder) {
        points.forEach(point -> builder.addPoint(point.getIdentifier(), point.getLocation(), point.getTags()));
    }

    private static void addPointsForLines(Atlas atlas, Iterable<Line> lines, PackedAtlasBuilder builder) {
        lines.forEach(line -> line.getRawGeometry().forEach(location -> atlas.pointsAt((Location)location).forEach(point -> {
            if (!SubAtlasCreator.hasEntity(point, builder)) {
                builder.addPoint(point.getIdentifier(), point.getLocation(), point.getTags());
            }
        })));
    }

    private static void addRelationMembers(Relation relation, PackedAtlasBuilder builder) {
        Set<AtlasObject> relationMembers = relation.flatten();
        SubAtlasCreator.addEdges(relationMembers.stream().filter(member -> member instanceof Edge).collect(Collectors.toSet()), edge -> !SubAtlasCreator.hasEntity(edge, builder), builder);
        SubAtlasCreator.addAreas(relationMembers.stream().filter(member -> member instanceof Area && !SubAtlasCreator.hasEntity((Area)member, builder)).collect(Collectors.toSet()), builder);
        SubAtlasCreator.addLines(relationMembers.stream().filter(member -> member instanceof Line && !SubAtlasCreator.hasEntity((Line)member, builder)).collect(Collectors.toSet()), builder);
        SubAtlasCreator.addPoints(relationMembers.stream().filter(member -> member instanceof Point && !SubAtlasCreator.hasEntity((Point)member, builder)).collect(Collectors.toSet()), builder);
    }

    private static void addRelations(Atlas atlas, Iterable<Relation> relations, Predicate<Relation> validRelationTest, Predicate<RelationMember> validMemberTest, PackedAtlasBuilder builder, AtlasCutType cutType) {
        Iterables.stream(relations).filter(validRelationTest).forEach(relation -> {
            List<RelationMember> validMembers = relation.members().stream().filter(validMemberTest).collect(Collectors.toList());
            if (!validMembers.isEmpty()) {
                if (AtlasCutType.SOFT_CUT.equals((Object)cutType) || AtlasCutType.SILK_CUT.equals((Object)cutType)) {
                    validMembers.forEach(member -> {
                        if (member.getEntity() instanceof Relation && !SubAtlasCreator.hasEntity(member.getEntity(), builder)) {
                            SubAtlasCreator.addAllSubRelations(atlas, (Relation)member.getEntity(), builder);
                        }
                    });
                }
                RelationBean structure = new RelationBean();
                validMembers.forEach(validMember -> structure.addItem(validMember.getEntity().getIdentifier(), validMember.getRole(), ItemType.forEntity(validMember.getEntity())));
                builder.addRelation(relation.getIdentifier(), relation.getOsmIdentifier(), structure, relation.getTags());
            } else {
                logger.trace("Excluding relation {} from sub-atlas since none of its members pass the {} cut.", (Object)relation.getIdentifier(), (Object)AtlasCutType.HARD_CUT_ALL);
            }
        });
    }

    private static <M extends AtlasEntity> Supplier<Iterable<M>> getContainmentCachingSupplier(Atlas atlas, Iterable<M> source, ItemType type) {
        HashSet memberIdentifiersWithin = new HashSet();
        Supplier<Iterable<M>> result = () -> {
            if (memberIdentifiersWithin.isEmpty()) {
                return Iterables.stream(source).map(member -> {
                    memberIdentifiersWithin.add(member.getIdentifier());
                    return member;
                }).collect();
            }
            return Iterables.stream(memberIdentifiersWithin).map(entityIdentifier -> atlas.entity((long)entityIdentifier, type)).collect();
        };
        return result;
    }

    private static <M extends AtlasEntity> Supplier<Iterable<M>> getIntersectingCachingSupplier(Atlas atlas, Iterable<M> source, ItemType type) {
        HashSet memberIdentifiersIntersecting = new HashSet();
        Supplier<Iterable<M>> result = () -> {
            if (memberIdentifiersIntersecting.isEmpty()) {
                return Iterables.stream(source).map(member -> {
                    memberIdentifiersIntersecting.add(member.getIdentifier());
                    return member;
                }).collect();
            }
            return Iterables.stream(memberIdentifiersIntersecting).map(entityIdentifier -> atlas.entity((long)entityIdentifier, type)).collect();
        };
        return result;
    }

    private static PackedAtlasBuilder getPackedAtlasBuilder(Atlas atlas, AtlasSize sizeEstimates) {
        return new PackedAtlasBuilder().withSizeEstimates(sizeEstimates).withMetaData(atlas.metaData()).withName(String.format("%s%s", atlas.getName(), SUB_ATLAS_NAME_POSTFIX));
    }

    private static boolean hasEntity(AtlasEntity entity, PackedAtlasBuilder builder) {
        switch (entity.getType()) {
            case POINT: {
                return builder.peek().point(entity.getIdentifier()) != null;
            }
            case NODE: {
                return builder.peek().node(entity.getIdentifier()) != null;
            }
            case EDGE: {
                return builder.peek().edge(entity.getIdentifier()) != null;
            }
            case LINE: {
                return builder.peek().line(entity.getIdentifier()) != null;
            }
            case AREA: {
                return builder.peek().area(entity.getIdentifier()) != null;
            }
            case RELATION: {
                return builder.peek().relation(entity.getIdentifier()) != null;
            }
        }
        return false;
    }

    private SubAtlasCreator() {
    }
}

