/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.weird;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.Coverage;
import org.slf4j.Logger;

public class NodesPerLength
extends Coverage<Edge> {
    public NodesPerLength(Logger logger, Atlas atlas) {
        super(logger, atlas);
    }

    public NodesPerLength(Logger logger, Atlas atlas, Predicate<Edge> filter) {
        super(logger, atlas, filter);
    }

    @Override
    protected Coverage.CoverageType coverageType() {
        return Coverage.CoverageType.DISTANCE;
    }

    @Override
    protected Iterable<Edge> getEntities() {
        return this.getAtlas().edges();
    }

    @Override
    protected Set<String> getKeys(Edge item) {
        return new HashSet<String>();
    }

    @Override
    protected String getUnit() {
        return "Nodes per km";
    }

    @Override
    protected double getValue(Edge item) {
        return (double)item.asPolyLine().size() / item.length().asKilometers();
    }

    @Override
    protected boolean isCounted(Edge item) {
        return true;
    }

    @Override
    protected String subType() {
        return "true";
    }

    @Override
    protected String type() {
        return "nodes_per_km";
    }
}

