/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.statistics.coverage.poi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.Coverage;
import org.openstreetmap.atlas.geography.atlas.statistics.coverage.poi.SimpleCoverage;
import org.openstreetmap.atlas.tags.Taggable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastUserNameCountCoverage
extends SimpleCoverage<AtlasEntity> {
    private static final Logger logger = LoggerFactory.getLogger(LastUserNameCountCoverage.class);
    private final long cutoff;

    public LastUserNameCountCoverage(Atlas atlas, long cutoff) {
        super(logger, atlas, Coverage.CoverageType.COUNT);
        this.cutoff = cutoff;
    }

    @Override
    public Map<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> getStatistic() {
        Map<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> old = super.getStatistic();
        double total = 0.0;
        for (Map.Entry<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> entry : old.entrySet()) {
            if (entry.getKey().getTag().equals("all")) continue;
            total += entry.getValue().getCount();
        }
        double totalCount = total;
        HashMap<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue> result = new HashMap<AtlasStatistics.StatisticKey, AtlasStatistics.StatisticValue>();
        ArrayList<Double> aggregatedCounts = new ArrayList<Double>();
        aggregatedCounts.add(0.0);
        old.forEach((oldKey, oldValue) -> {
            if (oldValue.getCount() >= (double)this.cutoff) {
                if (!oldKey.getTag().equals("all")) {
                    AtlasStatistics.StatisticKey key = new AtlasStatistics.StatisticKey("", oldKey.getType(), oldKey.getTag());
                    AtlasStatistics.StatisticValue value = new AtlasStatistics.StatisticValue(oldValue.getCount(), totalCount);
                    result.put(key, value);
                }
            } else {
                aggregatedCounts.set(0, (Double)aggregatedCounts.get(0) + oldValue.getCount());
            }
        });
        result.put(new AtlasStatistics.StatisticKey("", this.type(), "_all_others_below_" + this.cutoff), new AtlasStatistics.StatisticValue((Double)aggregatedCounts.get(0), totalCount));
        return result;
    }

    @Override
    protected Iterable<AtlasEntity> getEntities() {
        return this.getAtlas();
    }

    @Override
    protected Set<String> getKeys(AtlasEntity item) {
        HashSet<String> result = new HashSet<String>();
        Optional<String> lastUser = item.lastUserName();
        if (lastUser.isPresent()) {
            result.add(lastUser.get());
        } else {
            result.add("unknown_last_user");
        }
        return result;
    }

    @Override
    protected String type() {
        return "last_edit_user_name";
    }

    @Override
    protected Predicate<Taggable> validKeyValuePairs() {
        return taggable -> true;
    }
}

