/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.routing;

import java.util.HashSet;
import java.util.PriorityQueue;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.routing.AbstractRouter;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class AStarRouter
extends AbstractRouter {
    private final Heuristic heuristic;

    public static AStarRouter balanced(Atlas atlas, Distance threshold) {
        double distanceFromStartCostRatio = 0.25;
        return new AStarRouter(atlas, threshold, (start, candidate, end) -> 0.25 * start.getLocation().distanceTo(candidate.getLocation()).asMeters() + 0.75 * candidate.getLocation().distanceTo(end.getLocation()).asMeters());
    }

    public static AStarRouter dijkstra(Atlas atlas, Distance threshold) {
        return new AStarRouter(atlas, threshold, (start, candidate, end) -> start.getLocation().distanceTo(candidate.getLocation()).asMeters());
    }

    public static AStarRouter fastComputationAndSubOptimalRoute(Atlas atlas, Distance threshold) {
        return new AStarRouter(atlas, threshold, (start, candidate, end) -> candidate.getLocation().distanceTo(end.getLocation()).asMeters());
    }

    public AStarRouter(Atlas atlas, Distance threshold, Heuristic heuristic) {
        super(atlas, threshold);
        this.heuristic = heuristic;
    }

    @Override
    public Route route(Node start, Node end) {
        if (start.equals(end)) {
            return null;
        }
        if (start.outEdges().isEmpty()) {
            return null;
        }
        if (end.inEdges().isEmpty()) {
            return null;
        }
        PriorityQueue<Candidate> candidates = new PriorityQueue<Candidate>();
        HashSet<Edge> explored = new HashSet<Edge>();
        for (Edge edge : start.outEdges()) {
            if (end.equals(edge.end())) {
                return Route.forEdge(edge);
            }
            candidates.add(new Candidate(Route.forEdge(edge), this.heuristic.cost(start, edge.end(), end)));
        }
        while (!candidates.isEmpty()) {
            Candidate best = (Candidate)candidates.poll();
            if (end.equals(best.lastNode())) {
                return best.getRoute();
            }
            for (Edge edge : best.lastNode().outEdges()) {
                if (explored.contains(edge)) continue;
                candidates.add(best.withNewEdge(edge, this.heuristic.cost(start, edge.end(), end)));
            }
            explored.add(best.lastEdge());
        }
        return null;
    }

    private static class Candidate
    implements Comparable<Candidate> {
        private final Route route;
        private final double cost;

        Candidate(Route route, double cost) {
            this.route = route;
            this.cost = cost;
        }

        @Override
        public int compareTo(Candidate other) {
            return this.getCost() > other.getCost() ? 1 : (this.getCost() == other.getCost() ? 0 : -1);
        }

        public double getCost() {
            return this.cost;
        }

        public Route getRoute() {
            return this.route;
        }

        public Edge lastEdge() {
            return this.getRoute().end();
        }

        public Node lastNode() {
            return this.lastEdge().end();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[Candidate: ");
            builder.append(this.route.toString());
            builder.append(", Cost: ");
            builder.append(this.cost);
            builder.append("]");
            return builder.toString();
        }

        public Candidate withNewEdge(Edge edge, double edgeCost) {
            return new Candidate(this.getRoute().append(edge), this.getCost() + edgeCost);
        }
    }

    public static interface Heuristic {
        public double cost(Node var1, Node var2, Node var3);
    }
}

