/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.base.Joiner;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeCounter {
    private static Logger logger = LoggerFactory.getLogger(RuntimeCounter.class);
    private static final int OUTPUT_THRESHOLD = 10000;
    private static long totalProcessed = 0L;
    private static long wayProcessed = 0L;
    private static long relationProcessed = 0L;
    private static long waySliced = 0L;
    private static long relationSliced = 0L;
    private static long geometryChecked = 0L;
    private static long geometryWithin = 0L;
    private static long geometryNoIntersect = 0L;
    private static long geometryIntersect = 0L;
    private static Set<Long> skippedWays = new HashSet<Long>();

    public static void geometryChecked() {
        ++geometryChecked;
    }

    public static void geometryCheckedIntersect() {
        ++geometryIntersect;
    }

    public static void geometryCheckedNoIntersect() {
        ++geometryNoIntersect;
    }

    public static void geometryCheckedWithin() {
        ++geometryWithin;
    }

    public static long getGeometryChecked() {
        return geometryChecked;
    }

    public static long getGeometryCheckedIntersect() {
        return geometryIntersect;
    }

    public static long getGeometryCheckedNoIntersect() {
        return geometryNoIntersect;
    }

    public static long getGeometryCheckedWithin() {
        return geometryWithin;
    }

    public static long getRelationProcessed() {
        return relationProcessed;
    }

    public static long getRelationSlicedProcessed() {
        return relationSliced;
    }

    public static Set<Long> getSkippedWays() {
        return skippedWays;
    }

    public static long getWayProcessed() {
        return wayProcessed;
    }

    public static long getWaySlicedProcessed() {
        return waySliced;
    }

    public static String print() {
        StringBuilder builder = new StringBuilder();
        builder.append("Way processed: ").append(wayProcessed).append(" ,Way Sliced: ").append(waySliced).append(" ,Relation processed: ").append(relationProcessed).append(" ,RelationSliced: ").append(relationSliced).append(" ,Geometry checked: ").append(geometryChecked).append(" ,Checked within:").append(geometryWithin).append(" ,Checked No Intersect: ").append(geometryNoIntersect).append(" ,Checked Intersect: ").append(geometryIntersect).append(" , Skipped Ways: ").append(Joiner.on(",").join(skippedWays));
        return builder.toString();
    }

    public static void relationProcessed() {
        RuntimeCounter.totalProcessed();
        ++relationProcessed;
    }

    public static void relationSliced() {
        ++relationSliced;
    }

    public static void wayProcessed() {
        RuntimeCounter.totalProcessed();
        ++wayProcessed;
    }

    public static void waySkipped(long skipped) {
        skippedWays.add(skipped);
    }

    public static void waySliced() {
        ++waySliced;
    }

    private static void totalProcessed() {
        if (++totalProcessed % 10000L == 0L) {
            logger.info(RuntimeCounter.print());
        }
    }

    private RuntimeCounter() {
    }
}

