/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.PrecisionReducerCoordinateOperation;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CountryCodeProperties;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicingStatistic;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryPoint;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsLinearRingConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsLocationConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolyLineConverter;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.SyntheticNearestNeighborCountryCodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RawAtlasSlicer {
    protected static final JtsPolygonConverter JTS_POLYGON_CONVERTER = new JtsPolygonConverter();
    protected static final JtsPolyLineConverter JTS_POLYLINE_CONVERTER = new JtsPolyLineConverter();
    protected static final JtsLocationConverter JTS_LOCATION_CONVERTER = new JtsLocationConverter();
    protected static final JtsLinearRingConverter JTS_LINEAR_RING_CONVERTER = new JtsLinearRingConverter();
    protected static final MultiplePolyLineToPolygonsConverter MULTIPLE_POLY_LINE_TO_POLYGON_CONVERTER = new MultiplePolyLineToPolygonsConverter();
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasSlicer.class);
    private static final Integer SEVEN_DIGIT_PRECISION_SCALE = 10000000;
    private static final PrecisionModel PRECISION_MODEL = new PrecisionModel(SEVEN_DIGIT_PRECISION_SCALE.intValue());
    protected static final PrecisionReducerCoordinateOperation PRECISION_REDUCER = new PrecisionReducerCoordinateOperation(PRECISION_MODEL, true);
    protected static final Distance SNAP_DISTANCE = Distance.inches(24.0);
    private final AtlasLoadingOption loadingOption;
    private final RawAtlasSlicingStatistic statistics = new RawAtlasSlicingStatistic(logger);
    private final CoordinateToNewPointMapping newPointCoordinates;
    private final String shardOrAtlasName;
    private final Atlas startingAtlas;

    protected static Map<String, String> createLineTags(Geometry geometry, Map<String, String> tags) {
        String countryCode = CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code");
        tags.put("iso_country_code", countryCode);
        String usingNearestNeighbor = CountryBoundaryMap.getGeometryProperty(geometry, "nearest_neighbor_country_code");
        if (usingNearestNeighbor != null) {
            tags.put("nearest_neighbor_country_code", usingNearestNeighbor);
        }
        return tags;
    }

    protected static TemporaryPoint createNewPoint(Coordinate coordinate, long pointIdentifier, Map<String, String> pointTags) {
        pointTags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
        return new TemporaryPoint(pointIdentifier, JTS_LOCATION_CONVERTER.backwardConvert(coordinate), pointTags);
    }

    protected static boolean fromSameCountry(Line one, Line two) {
        Optional<String> firstTagValue = one.getTag("iso_country_code");
        Optional<String> secondTagValue = two.getTag("iso_country_code");
        if (firstTagValue.isPresent() && secondTagValue.isPresent()) {
            HashSet<String> firstCountries = new HashSet<String>(Arrays.asList(firstTagValue.get().split(",")));
            HashSet<String> secondCountries = new HashSet<String>(Arrays.asList(secondTagValue.get().split(",")));
            firstCountries.retainAll(new HashSet<String>(secondCountries));
            return !firstCountries.isEmpty();
        }
        throw new CoreException("All raw Atlas lines must have a country code by the time Relation slicing is done. One of the two Lines {} or {} does not!", one.getIdentifier(), two.getIdentifier());
    }

    public RawAtlasSlicer(AtlasLoadingOption loadingOption, CoordinateToNewPointMapping newPointCoordinates, Atlas startingAtlas) {
        this.loadingOption = loadingOption;
        this.newPointCoordinates = newPointCoordinates;
        this.startingAtlas = startingAtlas;
        this.shardOrAtlasName = this.getShardOrAtlasName(startingAtlas);
    }

    public String getShardOrAtlasName() {
        return this.shardOrAtlasName;
    }

    public Atlas getStartingAtlas() {
        return this.startingAtlas;
    }

    public abstract Atlas slice();

    protected Map<String, String> createPointTags(Location location, boolean fromRawAtlas) {
        HashMap<String, String> tags = new HashMap<String, String>();
        CountryCodeProperties countryDetails = this.getCountryBoundaryMap().getCountryCodeISO3(location);
        if (countryDetails.inMultipleCountries()) {
            tags.put("iso_country_code", Joiner.on(",").join(Sets.newTreeSet(Arrays.asList(countryDetails.getIso3CountryCode().split(",")))));
        } else {
            tags.put("iso_country_code", countryDetails.getIso3CountryCode());
        }
        if (countryDetails.usingNearestNeighbor()) {
            tags.put("nearest_neighbor_country_code", SyntheticNearestNeighborCountryCodeTag.YES.toString());
            tags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
        }
        if (fromRawAtlas && countryDetails.inMultipleCountries()) {
            tags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.EXISTING.toString());
        }
        return tags;
    }

    protected CoordinateToNewPointMapping getCoordinateToPointMapping() {
        return this.newPointCoordinates;
    }

    protected Set<String> getCountries() {
        if (this.loadingOption.getCountryCodes().isEmpty()) {
            HashSet<String> allCountryCodes = new HashSet<String>();
            allCountryCodes.addAll(this.loadingOption.getCountryBoundaryMap().allCountryNames());
            this.loadingOption.setAdditionalCountryCodes(allCountryCodes);
        }
        return this.loadingOption.getCountryCodes();
    }

    protected CountryBoundaryMap getCountryBoundaryMap() {
        return this.loadingOption.getCountryBoundaryMap();
    }

    protected Set<IsoCountry> getIsoCountries() {
        HashSet<IsoCountry> isoCountries = new HashSet<IsoCountry>();
        if (this.loadingOption.getCountryCodes().isEmpty()) {
            this.loadingOption.setAdditionalCountryCodes(this.loadingOption.getCountryBoundaryMap().allCountryNames());
        }
        this.loadingOption.getCountryCodes().forEach(countryCode -> isoCountries.add(IsoCountry.forCountryCode(countryCode).get()));
        return isoCountries;
    }

    protected RawAtlasSlicingStatistic getStatistics() {
        return this.statistics;
    }

    protected boolean isAtlasEdge(Line line) {
        return this.loadingOption.getEdgeFilter().test(line);
    }

    protected boolean isInsideWorkingBound(AtlasEntity entity) {
        Optional<String> countryCodes = entity.getTag("iso_country_code");
        if (countryCodes.isPresent() && this.getCountries() != null && !this.getCountries().isEmpty()) {
            for (String countryCode : countryCodes.get().split(",")) {
                if (!this.getCountries().contains(countryCode)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isOutsideWorkingBound(Geometry geometry) {
        String countryCode = CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code");
        if (countryCode != null) {
            return this.getCountries() != null && !this.getCountries().isEmpty() && !this.getCountries().contains(countryCode);
        }
        return false;
    }

    protected boolean shouldForceSlicing(Taggable ... source) {
        if (this.loadingOption.getForceSlicingFilter() == null) {
            return false;
        }
        return source != null && source.length > 0 && this.loadingOption.getForceSlicingFilter().test(source[0]);
    }

    protected boolean shouldSkipSlicing(List<Polygon> candidates, Taggable ... source) {
        return CountryBoundaryMap.isSameCountry(candidates) && !this.shouldForceSlicing(source);
    }

    private String getShardOrAtlasName(Atlas atlas) {
        return atlas.metaData().getShardName().orElse(atlas.getName());
    }
}

