/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsUtility;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.tags.ISOCountryTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.SyntheticRelationMemberAdded;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.identifiers.EntityIdentifierGenerator;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasRelationSlicer
extends RawAtlasSlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasRelationSlicer.class);
    private final Shard initialShard;
    private final Set<Long> pointCandidatesForRemoval;
    private final Map<Long, Map<String, CompleteRelation>> splitRelations = new HashMap<Long, Map<String, CompleteRelation>>();
    private final Set<FeatureChange> changes = new HashSet<FeatureChange>();
    private final Map<Long, CompleteLine> newLineCountries = new HashMap<Long, CompleteLine>();
    private final Set<Long> deletedRelations = new HashSet<Long>();
    private final Predicate<AtlasEntity> isInCountry;

    public RawAtlasRelationSlicer(Atlas atlas, Shard initialShard, AtlasLoadingOption loadingOption) {
        super(loadingOption, new CoordinateToNewPointMapping(), atlas);
        this.initialShard = initialShard;
        this.pointCandidatesForRemoval = new HashSet<Long>();
        this.isInCountry = entity -> ISOCountryTag.isIn(this.getCountries()).test((Taggable)entity);
    }

    @Override
    public Atlas slice() {
        Time time = Time.now();
        logger.info("Starting relation slicing for Atlas {}", (Object)this.getShardOrAtlasName());
        this.sliceRelations();
        logger.info("Finished slicing relations for Atlas {}", (Object)this.getShardOrAtlasName());
        this.removeDeletedPoints();
        logger.info("Finished relation slicing for Atlas {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        if (this.changes.isEmpty()) {
            return this.cutSubAtlasForOriginalShard(this.getStartingAtlas());
        }
        return this.cutSubAtlasForOriginalShard(new ChangeAtlas(this.getStartingAtlas(), new ChangeBuilder().addAll(this.changes).get()));
    }

    private List<LinearRing> buildRings(List<RelationMember> members, long relationIdentifier) {
        ArrayList<LinearRing> results = new ArrayList<LinearRing>();
        ArrayList<PolyLine> linePieces = new ArrayList<PolyLine>(members.size());
        for (RelationMember member : members) {
            Line line = this.getStartingAtlas().line(member.getEntity().getIdentifier());
            if (line == null) {
                throw new CoreException("Relation {} has a member {} that's not in the original Atlas {}", relationIdentifier, member.getEntity().getIdentifier(), this.getShardOrAtlasName());
            }
            linePieces.add(line.asPolyLine());
        }
        try {
            Iterable<Polygon> polygons = MULTIPLE_POLY_LINE_TO_POLYGON_CONVERTER.convert((Iterable<PolyLine>)linePieces);
            polygons.forEach(polygon -> results.add(JTS_LINEAR_RING_CONVERTER.convert((Polygon)polygon)));
        }
        catch (Exception e) {
            logger.error("One of the members for relation {} for Atlas {} is invalid and does not form a closed ring!", new Object[]{relationIdentifier, this.getShardOrAtlasName(), e});
        }
        return results;
    }

    private List<LineString> clipBoundary(long identifier, org.locationtech.jts.geom.Polygon geometry, CountryBoundaryMap boundary) {
        ArrayList<LineString> results = new ArrayList<LineString>();
        if (Objects.isNull(geometry)) {
            return results;
        }
        org.locationtech.jts.geom.Polygon target = geometry;
        List polygons = boundary.query(target.getEnvelopeInternal()).stream().distinct().collect(Collectors.toList());
        if (CountryBoundaryMap.isSameCountry(polygons)) {
            return results;
        }
        List polygonsForSlicedCountries = polygons.stream().distinct().filter(polygon -> this.getCountries().contains(CountryBoundaryMap.getGeometryProperty(polygon, "iso_country_code"))).collect(Collectors.toList());
        for (org.locationtech.jts.geom.Polygon polygon2 : polygonsForSlicedCountries) {
            IntersectionMatrix matrix = target.relate(polygon2);
            if (matrix.isWithin()) {
                return results;
            }
            if (!matrix.isIntersects()) continue;
            Geometry clipped = target.intersection(polygon2.getExteriorRing());
            String countryCode = CountryBoundaryMap.getGeometryProperty(polygon2, "iso_country_code");
            if (clipped.isEmpty()) continue;
            if (clipped instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)clipped;
                LineMerger merger = new LineMerger();
                CountryBoundaryMap.geometries(collection).forEach(merger::add);
                merger.getMergedLineStrings().forEach(lineString -> CountryBoundaryMap.setGeometryProperty((Geometry)lineString, "iso_country_code", countryCode));
                results.addAll(merger.getMergedLineStrings());
                continue;
            }
            if (clipped instanceof LineString) {
                CountryBoundaryMap.setGeometryProperty(clipped, "iso_country_code", countryCode);
                results.add((LineString)clipped);
                continue;
            }
            throw new CoreException("Unexpected geometry {} encountered while slicing relation {}.", clipped, identifier);
        }
        return results;
    }

    private boolean containsSlicedMember(Iterable<RelationMember> members) {
        for (RelationMember member : members) {
            if (new ReverseIdentifierFactory().getCountryCode(member.getEntity().getIdentifier()) == 0L) continue;
            return true;
        }
        return false;
    }

    private CompleteLine createNewBorderLineMemberForRelation(LineString lineString, List<RelationMember> outers, long relationIdentifier) {
        ArrayList<Location> newLineLocations = new ArrayList<Location>(lineString.getNumPoints());
        for (Coordinate coordinate : lineString.getCoordinates()) {
            newLineLocations.add(JTS_LOCATION_CONVERTER.backwardConvert(coordinate));
        }
        PolyLine initialLine = new PolyLine((List<? extends Location>)newLineLocations);
        for (RelationMember outer : outers) {
            if (!((Line)outer.getEntity()).asPolyLine().overlapsShapeOf(initialLine)) continue;
            logger.warn("Skipping line as it overlaps with existing outer");
            return null;
        }
        Location originalFirst = (Location)newLineLocations.get(0);
        Location originalLast = (Location)newLineLocations.get(newLineLocations.size() - 1);
        boolean firstSnapped = false;
        boolean lastSnapped = false;
        for (RelationMember outer : outers) {
            Location outerLineFirst = ((Line)outer.getEntity()).asPolyLine().first();
            Location outerLineLast = ((Line)outer.getEntity()).asPolyLine().last();
            if (!firstSnapped || outerLineLast.distanceTo(originalFirst).isLessThan(((Location)newLineLocations.get(0)).distanceTo(originalFirst))) {
                newLineLocations.set(0, outerLineLast);
                firstSnapped = true;
            }
            if (lastSnapped && !outerLineFirst.distanceTo(originalLast).isLessThan(((Location)newLineLocations.get(newLineLocations.size() - 1)).distanceTo(originalLast))) continue;
            newLineLocations.set(newLineLocations.size() - 1, outerLineFirst);
            lastSnapped = true;
        }
        if (((Location)newLineLocations.get(0)).distanceTo(originalFirst).isGreaterThan(SNAP_DISTANCE)) {
            logger.error("For relation {}, snapped first location by {} feet, not adding synthetic line", (Object)relationIdentifier, (Object)((Location)newLineLocations.get(0)).distanceTo(originalFirst).asFeet());
            return null;
        }
        if (((Location)newLineLocations.get(newLineLocations.size() - 1)).distanceTo(originalLast).isGreaterThan(SNAP_DISTANCE)) {
            logger.error("For relation {}, snapped last location by {} feet, not adding synthetic line", (Object)relationIdentifier, (Object)((Location)newLineLocations.get(newLineLocations.size() - 1)).distanceTo(originalLast).asFeet());
            return null;
        }
        Map<String, String> newLineTags = RawAtlasRelationSlicer.createLineTags(lineString, new HashMap<String, String>());
        EntityIdentifierGenerator lineIdentifierGenerator = new EntityIdentifierGenerator();
        CompleteLine newLine = new CompleteLine(0L, new PolyLine((List<? extends Location>)newLineLocations), newLineTags, new HashSet<Long>());
        newLine.withIdentifier(lineIdentifierGenerator.generateIdentifier(newLine));
        this.newLineCountries.put(newLine.getIdentifier(), newLine);
        return newLine;
    }

    private CompleteLine createNewMergedLineMemberForRelation(LineString lineString) {
        Map<String, String> newLineTags = RawAtlasRelationSlicer.createLineTags(lineString, new HashMap<String, String>());
        EntityIdentifierGenerator lineIdentifierGenerator = new EntityIdentifierGenerator();
        CompleteLine newLine = new CompleteLine(0L, JTS_POLYLINE_CONVERTER.backwardConvert(lineString), newLineTags, new HashSet<Long>());
        newLine.withIdentifier(lineIdentifierGenerator.generateIdentifier(newLine));
        this.newLineCountries.put(newLine.getIdentifier(), newLine);
        return newLine;
    }

    private Atlas cutSubAtlasForOriginalShard(Atlas atlas) {
        try {
            if (this.initialShard != null) {
                Optional<Atlas> countrySubAtlas = atlas.subAtlas(this.isInCountry, AtlasCutType.SILK_CUT);
                if (countrySubAtlas.isPresent()) {
                    Optional<Atlas> finalSubAtlas = countrySubAtlas.get().subAtlas(this.initialShard.bounds(), AtlasCutType.SILK_CUT);
                    if (finalSubAtlas.isPresent()) {
                        return finalSubAtlas.get();
                    }
                    return null;
                }
                return null;
            }
            return atlas;
        }
        catch (Exception e) {
            throw new CoreException("Error creating sub-atlas for original shard bounds", e);
        }
    }

    private MultiMap<Integer, Integer> findIntersectingMembers(List<Line> closedOuterLines, List<Line> closedInnerLines) {
        MultiMap<Integer, Integer> outerToInnerIntersectionMap = new MultiMap<Integer, Integer>();
        if (!closedOuterLines.isEmpty() && !closedInnerLines.isEmpty()) {
            for (int innerIndex = 0; innerIndex < closedInnerLines.size(); ++innerIndex) {
                Line inner = closedInnerLines.get(innerIndex);
                for (int outerIndex = 0; outerIndex < closedOuterLines.size(); ++outerIndex) {
                    Line outer = closedOuterLines.get(outerIndex);
                    if (!RawAtlasRelationSlicer.fromSameCountry(outer, inner) || !outer.intersects(new Polygon(inner))) continue;
                    outerToInnerIntersectionMap.add(outerIndex, innerIndex);
                }
            }
        }
        return outerToInnerIntersectionMap;
    }

    private List<RelationMember> generateMemberList(long relationIdentifier, List<RelationMember> members, boolean closed) {
        if (members != null && !members.isEmpty()) {
            return members.stream().filter(member -> {
                Line line = this.getStartingAtlas().line(member.getEntity().getIdentifier());
                if (line == null) {
                    logger.error("Line member {} for Relation {} is not the in Atlas {}", new Object[]{member.getEntity().getIdentifier(), relationIdentifier, this.getShardOrAtlasName()});
                    return false;
                }
                boolean isClosed = line.isClosed();
                return closed ? isClosed : !isClosed;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private AtlasEntity getCompleteEntity(AtlasEntity entity) {
        if (entity.getType().equals((Object)ItemType.AREA)) {
            return CompleteArea.from(this.getStartingAtlas().area(entity.getIdentifier()));
        }
        if (entity.getType().equals((Object)ItemType.EDGE)) {
            return CompleteEdge.from(this.getStartingAtlas().edge(entity.getIdentifier()));
        }
        if (entity.getType().equals((Object)ItemType.LINE)) {
            if (entity instanceof CompleteEntity) {
                return this.newLineCountries.get(entity.getIdentifier());
            }
            return CompleteLine.from(this.getStartingAtlas().line(entity.getIdentifier()));
        }
        if (entity.getType().equals((Object)ItemType.POINT)) {
            return CompletePoint.from(this.getStartingAtlas().point(entity.getIdentifier()));
        }
        if (entity.getType().equals((Object)ItemType.NODE)) {
            return CompleteNode.from(this.getStartingAtlas().node(entity.getIdentifier()));
        }
        return CompleteRelation.from(this.getStartingAtlas().relation(entity.getIdentifier()));
    }

    private Map<Integer, List<LinearRing>> getOuterToInnerMap(Relation relation, List<LinearRing> outerRings, List<RelationMember> inners) {
        HashMap<Integer, List<LinearRing>> outerToInnerMap = new HashMap<Integer, List<LinearRing>>();
        for (int i = 0; i < outerRings.size(); ++i) {
            outerToInnerMap.put(i, new ArrayList());
        }
        if (inners == null || inners.isEmpty()) {
            return outerToInnerMap;
        }
        ArrayList<LinearRing> innerRings = new ArrayList<LinearRing>();
        ArrayList<RelationMember> nonClosedInners = new ArrayList<RelationMember>();
        nonClosedInners.addAll(this.generateMemberList(relation.getIdentifier(), inners, false));
        innerRings.addAll(this.buildRings(nonClosedInners, relation.getIdentifier()));
        if (innerRings.isEmpty()) {
            return outerToInnerMap;
        }
        for (int innerIndex = 0; innerIndex < innerRings.size(); ++innerIndex) {
            LinearRing inner = (LinearRing)innerRings.get(innerIndex);
            boolean foundEnclosingOuter = false;
            for (int outerIndex = 0; outerIndex < outerRings.size(); ++outerIndex) {
                LinearRing outer = outerRings.get(outerIndex);
                org.locationtech.jts.geom.Polygon outerPolygon = new org.locationtech.jts.geom.Polygon(outer, null, JtsUtility.GEOMETRY_FACTORY);
                if (!outerPolygon.contains(inner)) continue;
                foundEnclosingOuter = true;
                ((List)outerToInnerMap.get(outerIndex)).add((LinearRing)innerRings.get(innerIndex));
            }
            if (foundEnclosingOuter) continue;
            logger.error("Found isolated inner member for Multipolygon Relation geometry while slicing Atlas {}: {}", (Object)this.getShardOrAtlasName(), (Object)inner);
        }
        return outerToInnerMap;
    }

    private Map<String, List<RelationMember>> groupRelationMembersByCountry(long relationIdentifier, RelationMemberList members) {
        MultiMap<String, RelationMember> countryEntityMap = new MultiMap<String, RelationMember>();
        Iterables.stream(members).forEach(member -> {
            switch (member.getEntity().getType()) {
                case RELATION: {
                    if (!this.splitRelations.containsKey(member.getEntity().getIdentifier())) break;
                    this.splitRelations.get(member.getEntity().getIdentifier()).keySet().forEach(country -> {
                        Relation splitRelation = this.splitRelations.get(member.getEntity().getIdentifier()).get(country);
                        RelationMember splitRelationMember = new RelationMember(member.getRole(), splitRelation, relationIdentifier);
                        countryEntityMap.add((String)country, splitRelationMember);
                    });
                    break;
                }
                case LINE: {
                    if (this.newLineCountries.containsKey(member.getEntity().getIdentifier())) {
                        Line line = this.newLineCountries.get(member.getEntity().getIdentifier());
                        RelationMember lineMember = new RelationMember(member.getRole(), line, relationIdentifier);
                        ISOCountryTag.all(line).forEach(country -> countryEntityMap.add((String)country, lineMember));
                        break;
                    }
                    CompleteLine line = CompleteLine.from(this.getStartingAtlas().line(member.getEntity().getIdentifier()));
                    RelationMember lineMember = new RelationMember(member.getRole(), line, relationIdentifier);
                    ISOCountryTag.all(line).forEach(country -> countryEntityMap.add((String)country, lineMember));
                    break;
                }
                default: {
                    CompletePoint point = CompletePoint.from(this.getStartingAtlas().point(member.getEntity().getIdentifier()));
                    RelationMember pointMember = new RelationMember(member.getRole(), point, relationIdentifier);
                    ISOCountryTag.all(point).forEach(country -> countryEntityMap.add((String)country, pointMember));
                }
            }
        });
        return countryEntityMap;
    }

    private void markRemovedMemberLineForDeletion(Line line, Relation relation) {
        boolean isPartOfOtherRelations = line.relations().stream().anyMatch(partOf -> partOf.getIdentifier() != relation.getIdentifier());
        logger.info("Removing line {} from relation {}", (Object)line, (Object)relation);
        if (!isPartOfOtherRelations) {
            this.changes.add(FeatureChange.remove(CompleteLine.shallowFrom(line), this.getStartingAtlas()));
            this.getStartingAtlas().line(line.getIdentifier()).asPolyLine().forEach(location -> this.getStartingAtlas().pointsAt((Location)location).forEach(point -> this.pointCandidatesForRemoval.add(point.getIdentifier())));
        } else {
            CompleteLine updatedLine = CompleteLine.shallowFrom(line);
            HashSet updatedParentRelations = new HashSet();
            line.relations().forEach(parentRelation -> {
                if (parentRelation.getIdentifier() != relation.getIdentifier()) {
                    updatedParentRelations.add(parentRelation.getIdentifier());
                }
            });
            updatedLine.withRelationIdentifiers((Set)updatedParentRelations);
            this.changes.add(FeatureChange.add(updatedLine, this.getStartingAtlas()));
        }
    }

    private void mergeOverlappingClosedMembers(CompleteRelation relation, List<RelationMember> outers, List<RelationMember> inners) {
        long relationIdentifier = relation.getIdentifier();
        List<RelationMember> closedOuters = this.generateMemberList(relationIdentifier, outers, true);
        List<RelationMember> closedInners = this.generateMemberList(relationIdentifier, inners, true);
        ArrayList<Line> closedOuterLines = new ArrayList<Line>();
        closedOuters.forEach(outer -> closedOuterLines.add(this.getStartingAtlas().line(outer.getEntity().getIdentifier())));
        ArrayList<Line> closedInnerLines = new ArrayList<Line>();
        closedInners.forEach(inner -> closedInnerLines.add(this.getStartingAtlas().line(inner.getEntity().getIdentifier())));
        MultiMap<Integer, Integer> outerToInnerIntersectionMap = this.findIntersectingMembers(closedOuterLines, closedInnerLines);
        HashSet<RelationMember> removedMembers = new HashSet<RelationMember>();
        HashSet<CompleteLine> addedMembers = new HashSet<CompleteLine>();
        for (Map.Entry<Integer, List<Integer>> entry : outerToInnerIntersectionMap.entrySet()) {
            int outerIndex = entry.getKey();
            List<Integer> innerIndices = entry.getValue();
            Geometry mergedMembers = null;
            Line outer2 = (Line)closedOuterLines.get(outerIndex);
            LinearRing outerRing = JTS_LINEAR_RING_CONVERTER.convert(new Polygon(outer2.getRawGeometry()));
            org.locationtech.jts.geom.Polygon outerPolygon = new org.locationtech.jts.geom.Polygon(outerRing, null, JtsUtility.GEOMETRY_FACTORY);
            for (int innerIndex : innerIndices) {
                Line inner2 = (Line)closedInnerLines.get(innerIndex);
                LinearRing innerRing = JTS_LINEAR_RING_CONVERTER.convert(new Polygon(inner2.getRawGeometry()));
                org.locationtech.jts.geom.Polygon innerPolygon = new org.locationtech.jts.geom.Polygon(innerRing, null, JtsUtility.GEOMETRY_FACTORY);
                try {
                    mergedMembers = outerPolygon.difference(innerPolygon);
                }
                catch (Exception e) {
                    logger.error("Error combining intersecting outer {} and inner {} members for Relation {} for Atlas {}", new Object[]{outer2, inner2, relationIdentifier, this.getShardOrAtlasName(), e});
                }
            }
            if (!(mergedMembers instanceof org.locationtech.jts.geom.Polygon) || !((org.locationtech.jts.geom.Polygon)mergedMembers).getExteriorRing().isClosed() || ((org.locationtech.jts.geom.Polygon)mergedMembers).getExteriorRing().isEmpty()) continue;
            LineString exteriorRing = ((org.locationtech.jts.geom.Polygon)mergedMembers).getExteriorRing();
            removedMembers.add(closedOuters.get(outerIndex));
            innerIndices.forEach(index -> closedOuters.add((RelationMember)closedInners.get((int)index)));
            this.markRemovedMemberLineForDeletion(outer2, relation);
            innerIndices.forEach(index -> this.markRemovedMemberLineForDeletion((Line)closedInnerLines.get((int)index), relation));
            Optional<String> possibleCountryCode = outer2.getTag("iso_country_code");
            if (!possibleCountryCode.isPresent()) {
                throw new CoreException("Relation {} contains member {} that is missing a country code for Atlas {}", relationIdentifier, outer2, this.getShardOrAtlasName());
            }
            CountryBoundaryMap.setGeometryProperty(exteriorRing, "iso_country_code", possibleCountryCode.get());
            addedMembers.add(this.createNewMergedLineMemberForRelation(exteriorRing));
        }
        ArrayList<RelationMember> updatedRelationMembers = new ArrayList<RelationMember>();
        for (RelationMember member2 : relation.members()) {
            if (this.getStartingAtlas().relation(relation.getIdentifier()).members().contains(member2)) continue;
            updatedRelationMembers.add(member2);
        }
        RelationMemberList relationMemberList = new RelationMemberList(Iterables.stream(this.getStartingAtlas().relation(relation.getIdentifier()).members()).filter(member -> !removedMembers.contains(member)));
        relation.withMembersAndSource(relationMemberList, this.getStartingAtlas().relation(relation.getIdentifier()));
        updatedRelationMembers.forEach(member -> relation.withAddedMember(this.getCompleteEntity(member.getEntity()), member.getRole()));
        addedMembers.forEach(newLine -> {
            this.changes.add(FeatureChange.add(newLine, this.getStartingAtlas()));
            relation.withAddedMember((AtlasEntity)newLine, "outer");
        });
    }

    private void patchNonClosedMembers(CompleteRelation relation, List<RelationMember> outers, List<RelationMember> inners) {
        long relationIdentifier = relation.getIdentifier();
        List<RelationMember> nonClosedOuters = this.generateMemberList(relationIdentifier, outers, false);
        if (nonClosedOuters.isEmpty()) {
            return;
        }
        List<LinearRing> outerRings = this.buildRings(nonClosedOuters, relationIdentifier);
        if (outerRings.isEmpty()) {
            return;
        }
        Map<Integer, List<LinearRing>> outerToInnerHoleMap = this.getOuterToInnerMap(relation, outerRings, inners);
        for (int outerIndex = 0; outerIndex < outerRings.size(); ++outerIndex) {
            LinearRing[] holes;
            LinearRing outerRing = outerRings.get(outerIndex);
            org.locationtech.jts.geom.Polygon polygon = new org.locationtech.jts.geom.Polygon(outerRing, holes = outerToInnerHoleMap.get(outerIndex).toArray(new LinearRing[0]), JtsUtility.GEOMETRY_FACTORY);
            if (!polygon.isValid()) {
                logger.error("Polygon created by Relation {} is invalid for Atlas {}", (Object)relationIdentifier, (Object)this.getShardOrAtlasName());
                return;
            }
            try {
                LinkedHashSet<LineString> borderLines = Sets.newLinkedHashSet(this.clipBoundary(relationIdentifier, polygon, this.getCountryBoundaryMap()));
                if (borderLines == null || borderLines.isEmpty()) {
                    return;
                }
                if ((long)borderLines.size() >= 1000L) {
                    logger.error("Borderline got cut into more than 999 pieces for Relation {} for Atlas {}", (Object)relationIdentifier, (Object)this.getShardOrAtlasName());
                    return;
                }
                for (LineString borderLine : borderLines) {
                    CompleteLine completeBorderLine = this.createNewBorderLineMemberForRelation(borderLine, outers, relation.getIdentifier());
                    if (completeBorderLine == null) continue;
                    this.changes.add(FeatureChange.add(completeBorderLine, this.getStartingAtlas()));
                    relation.withAddedMember((AtlasEntity)completeBorderLine, "outer");
                }
                continue;
            }
            catch (Exception e) {
                logger.error("Error processing Relation {} for Atlas {}, message: {}, geometry: {}", new Object[]{relationIdentifier, this.getShardOrAtlasName(), e.getMessage(), polygon.toString(), e});
            }
        }
    }

    private void removeDeletedPoints() {
        for (long identifier : this.pointCandidatesForRemoval) {
            Location location = this.getStartingAtlas().point(identifier).getLocation();
            boolean partOfExistingNonDeletedLine = !Iterables.isEmpty(this.getStartingAtlas().linesContaining(location));
            if (partOfExistingNonDeletedLine) continue;
            this.changes.add(FeatureChange.remove(CompletePoint.shallowFrom(this.getStartingAtlas().point(identifier))));
        }
    }

    private void sliceMultiPolygonRelation(Relation relation) {
        Map<String, List<RelationMember>> roleMap = relation.members().stream().filter(member -> member.getEntity().getType() == ItemType.LINE).collect(Collectors.groupingBy(RelationMember::getRole));
        List<RelationMember> outers = roleMap.get("outer");
        List<RelationMember> inners = roleMap.get("inner");
        CompleteRelation updatedRelation = CompleteRelation.from(relation);
        if (outers != null && !outers.isEmpty()) {
            this.patchNonClosedMembers(updatedRelation, outers, inners);
            if (inners != null && !inners.isEmpty() && this.containsSlicedMember(new MultiIterable<RelationMember>(outers, inners))) {
                this.mergeOverlappingClosedMembers(updatedRelation, outers, inners);
            }
        }
        this.splitRelation(updatedRelation);
    }

    private void sliceNonMultiPolygonRelation(Relation relation) {
        CompleteRelation updatedRelation = CompleteRelation.shallowFrom(relation);
        updatedRelation.withTags(relation.getTags());
        Map<String, List<RelationMember>> countryEntityMap = this.groupRelationMembersByCountry(relation.getIdentifier(), relation.members());
        ArrayList<RelationMember> relationMembers = new ArrayList<RelationMember>();
        countryEntityMap.entrySet().forEach(entry -> {
            if (this.getCountries().contains(entry.getKey()) || ISOCountryTag.join(this.getCountries()).equals(entry.getKey())) {
                relationMembers.addAll((Collection)entry.getValue());
            }
        });
        if (relationMembers.isEmpty()) {
            this.deletedRelations.add(relation.getIdentifier());
            this.changes.add(FeatureChange.remove(updatedRelation));
        } else {
            RelationMemberList updatedMembersList = new RelationMemberList(relationMembers);
            updatedRelation.withMembersAndSource(updatedMembersList, this.getStartingAtlas().relation(relation.getIdentifier()));
            ArrayList<String> countries = new ArrayList<String>();
            countryEntityMap.keySet().forEach(country -> {
                if (this.getCountries().contains(country)) {
                    countries.add((String)country);
                }
            });
            updatedRelation.withAddedTag("iso_country_code", ISOCountryTag.join(countries));
            this.changes.add(FeatureChange.add(updatedRelation));
            HashMap<String, CompleteRelation> relationByCountry = new HashMap<String, CompleteRelation>();
            relationByCountry.put(ISOCountryTag.join(countries), updatedRelation);
            this.splitRelations.put(updatedRelation.getIdentifier(), relationByCountry);
            relation.members().stream().filter(member -> !relationMembers.contains(member)).forEach(filteredMember -> {
                if (filteredMember.getEntity().getType() != ItemType.RELATION || !this.deletedRelations.contains(filteredMember.getEntity().getIdentifier())) {
                    CompleteEntity filteredEntity = (CompleteEntity)((Object)this.getCompleteEntity(filteredMember.getEntity()));
                    filteredEntity.withRemovedRelationIdentifier(relation.getIdentifier());
                    this.changes.add(FeatureChange.add((AtlasEntity)((Object)filteredEntity), this.getStartingAtlas()));
                }
            });
        }
    }

    private void sliceRelations() {
        this.getStartingAtlas().relationsLowerOrderFirst().forEach(relation -> {
            HashSet isoCountryCodes = new HashSet();
            relation.membersOfType(ItemType.LINE, ItemType.POINT).forEach(member -> isoCountryCodes.add(member.getEntity().getTag("iso_country_code").get()));
            if (Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.BOUNDARY, RelationTypeTag.MULTIPOLYGON}) && isoCountryCodes.size() > 1) {
                this.sliceMultiPolygonRelation((Relation)relation);
            } else {
                this.sliceNonMultiPolygonRelation((Relation)relation);
            }
        });
    }

    private void splitRelation(CompleteRelation currentRelation) {
        this.changes.add(FeatureChange.remove(CompleteRelation.shallowFrom(currentRelation), this.getStartingAtlas()));
        this.deletedRelations.add(currentRelation.getIdentifier());
        Map<String, List<RelationMember>> countryEntityMap = this.groupRelationMembersByCountry(currentRelation.getIdentifier(), currentRelation.members());
        List<Object> membersWithoutCountry = countryEntityMap.containsKey("N/A") ? countryEntityMap.remove("N/A") : Collections.emptyList();
        HashMap relationByCountry = new HashMap();
        CountrySlicingIdentifierFactory relationIdentifierFactory = new CountrySlicingIdentifierFactory(currentRelation.getIdentifier());
        ArrayList newRelationIds = new ArrayList();
        HashSet newRelations = new HashSet();
        countryEntityMap.entrySet().forEach(entry -> {
            RelationMemberList candidateMembers = new RelationMemberList((Iterable)entry.getValue());
            candidateMembers.addAll(membersWithoutCountry);
            if (!candidateMembers.isEmpty()) {
                long slicedRelationIdentifier = relationIdentifierFactory.nextIdentifier();
                newRelationIds.add(slicedRelationIdentifier);
                if (this.getCountries().contains(entry.getKey())) {
                    CompleteRelation newRelation = (CompleteRelation)CompleteRelation.from(currentRelation).withIdentifier(slicedRelationIdentifier).withMembers(candidateMembers).withAddedTag("iso_country_code", (String)entry.getKey());
                    newRelations.add(newRelation);
                }
            }
        });
        newRelations.forEach(newRelation -> {
            newRelation.withAllRelationsWithSameOsmIdentifier(newRelationIds);
            relationByCountry.put(newRelation.getTag("iso_country_code").get(), newRelation);
            HashSet<String> syntheticIds = new HashSet<String>();
            newRelation.members().forEach(member -> {
                if (this.newLineCountries.keySet().contains(member.getEntity().getIdentifier())) {
                    syntheticIds.add(Long.toString(member.getEntity().getIdentifier()));
                }
            });
            if (!syntheticIds.isEmpty()) {
                newRelation.withAddedTag("synthetic_relation_member_added", SyntheticRelationMemberAdded.join(syntheticIds));
            }
            this.changes.add(FeatureChange.add(newRelation));
        });
        this.splitRelations.put(currentRelation.getIdentifier(), relationByCountry);
    }
}

