/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.strtree.GeometryItemDistance;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.PointIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.SyntheticNearestNeighborCountryCodeTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasPointAndLineSlicer
extends RawAtlasSlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasPointAndLineSlicer.class);

    public RawAtlasPointAndLineSlicer(Atlas atlas, AtlasLoadingOption loadingOption) {
        super(loadingOption, new CoordinateToNewPointMapping(), atlas);
    }

    @Override
    public Atlas slice() {
        Time time = Time.now();
        logger.info("Starting line slicing for Atlas {}", (Object)this.getShardOrAtlasName());
        Atlas lineSlicedAtlas = this.sliceLines(this.getStartingAtlas());
        logger.info("Finished line slicing for Atlas {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        time = Time.now();
        logger.info("Starting point slicing for Atlas {}", (Object)this.getShardOrAtlasName());
        Atlas pointAndLineSlicedAtlas = this.slicePoints(lineSlicedAtlas);
        logger.info("Finished point slicing for Atlas {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        return pointAndLineSlicedAtlas.cloneToPackedAtlas();
    }

    private void addResult(Geometry geometry, List<Geometry> results) {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            CountryBoundaryMap.geometries(collection).forEach(part -> {
                CountryBoundaryMap.getGeometryProperties(geometry).forEach((key, value) -> CountryBoundaryMap.setGeometryProperty(part, key, value));
                this.addResult((Geometry)part, results);
            });
        } else if (this.isSignificantGeometry(geometry)) {
            results.add(geometry);
        } else if (logger.isErrorEnabled()) {
            logger.error("Resulting slice was trivial geometry {}, ignoring it.", (Object)geometry.toText());
        }
    }

    private boolean allLineTagsEqual(List<Geometry> slices) {
        if (slices == null || slices.isEmpty()) {
            return false;
        }
        Geometry firstSlice = slices.get(0);
        Map<String, String> tagMap = CountryBoundaryMap.getGeometryProperties(firstSlice);
        for (Geometry slice : slices) {
            if (CountryBoundaryMap.getGeometryProperties(slice).equals(tagMap)) continue;
            return false;
        }
        return true;
    }

    private List<Geometry> convertToJtsGeometryAndSlice(Line line) {
        long lineIdentifier = line.getIdentifier();
        Geometry geometry = line.isClosed() && !this.isAtlasEdge(line) ? JTS_POLYGON_CONVERTER.convert(new Polygon(line)) : JTS_POLYLINE_CONVERTER.convert(line.asPolyLine());
        List<Geometry> result = this.sliceGeometry(geometry, line);
        boolean multipolygonResult = Iterables.stream(result).anyMatch(geom -> geom instanceof org.locationtech.jts.geom.Polygon && ((org.locationtech.jts.geom.Polygon)geom).getNumInteriorRing() > 0);
        if (result.isEmpty() && line.isClosed() || multipolygonResult) {
            if (multipolygonResult) {
                logger.warn("Line {} for Atlas {} had multipolygon slicing result, falling back to polyline", (Object)line.getIdentifier(), (Object)this.getStartingAtlas().getName());
            }
            geometry = JTS_POLYLINE_CONVERTER.convert(line.asPolyLine());
            result = this.sliceGeometry(geometry, line);
        }
        if (result.isEmpty()) {
            String countryName = CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code");
            if (countryName == null || countryName.isEmpty()) {
                logger.error("Invalid Geometry for line {} for Atlas {}", (Object)lineIdentifier, (Object)this.getShardOrAtlasName());
            } else {
                result.add(geometry);
            }
        }
        return result;
    }

    private long createNewPointIdentifier(PointIdentifierFactory pointIdentifierFactory, long lineIdentifier) {
        while (pointIdentifierFactory.hasMore()) {
            long identifier = pointIdentifierFactory.nextIdentifier();
            if (this.getStartingAtlas().point(identifier) != null) continue;
            return identifier;
        }
        throw new CoreException("Slicing Line {} exceeded maximum number {} of supported new Points for Atlas {}", pointIdentifierFactory.getIdentifierScale(), lineIdentifier, this.getShardOrAtlasName());
    }

    private Geometry cutGeometry(long identifier, List<org.locationtech.jts.geom.Polygon> candidates, List<Geometry> results, Geometry target) {
        Geometry currentTarget = target;
        boolean fullyMatched = false;
        for (org.locationtech.jts.geom.Polygon candidate : candidates) {
            Geometry clipped;
            try {
                clipped = currentTarget.intersection(candidate);
            }
            catch (TopologyException exc) {
                logger.error("Error while using regular intersection for line {}, attempting again with reduced precision", (Object)identifier, (Object)exc);
                try {
                    GeometryPrecisionReducer precisionReducer = new GeometryPrecisionReducer(new PrecisionModel(1.0E8));
                    precisionReducer.setPointwise(true);
                    precisionReducer.setChangePrecisionModel(false);
                    currentTarget = precisionReducer.reduce(target);
                    clipped = currentTarget.intersection(candidate);
                }
                catch (Exception newExc) {
                    logger.error("Reduced precision still failed for line {}, rethrowing original exception", (Object)identifier, (Object)newExc);
                    throw exc;
                }
            }
            if (clipped.getNumPoints() <= 1) continue;
            String countryCode = CountryBoundaryMap.getGeometryProperty(candidate, "iso_country_code");
            CountryBoundaryMap.setGeometryProperty(clipped, "iso_country_code", countryCode);
            this.addResult(clipped, results);
            if (this.isSignificantGeometry(currentTarget = currentTarget.difference(candidate))) continue;
            DiscreteHausdorffDistance discreteHausdorffDistance = new DiscreteHausdorffDistance(currentTarget, candidate);
            if (!(discreteHausdorffDistance.orientedDistance() < 1.0E-6)) continue;
            fullyMatched = true;
            break;
        }
        return fullyMatched ? null : currentTarget;
    }

    private boolean isSignificantGeometry(Geometry geometry) {
        return geometry.getDimension() == 1 && geometry.getLength() > 1.0E-6 || geometry.getDimension() == 2 && geometry.getArea() > 1.0E-10;
    }

    private SortedMap<String, Collection<Geometry>> preprocessSlices(List<Geometry> slices) {
        TreeMap<String, Collection<Geometry>> processedSlices = new TreeMap<String, Collection<Geometry>>();
        Map<String, List<Geometry>> slicesByCountryCode = slices.stream().collect(Collectors.groupingBy(geometry -> CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")));
        slicesByCountryCode.keySet().forEach(countryCode -> {
            TreeSet sortedSlices = new TreeSet();
            List slicesForCountry = (List)slicesByCountryCode.get(countryCode);
            if (this.allLineTagsEqual(slicesForCountry)) {
                HashMap<String, String> lineTags = new HashMap<String, String>();
                lineTags.put("iso_country_code", (String)countryCode);
                CountryBoundaryMap.getGeometryProperties((Geometry)slicesForCountry.get(0)).forEach((key, value) -> {
                    if (!lineTags.containsKey(key)) {
                        lineTags.put((String)key, (String)value);
                    }
                });
                LineMerger merger = new LineMerger();
                merger.add(slicesForCountry);
                merger.getMergedLineStrings().forEach(geometry -> lineTags.forEach((key, value) -> CountryBoundaryMap.setGeometryProperty((Geometry)geometry, key, value)));
                sortedSlices.addAll(merger.getMergedLineStrings());
                processedSlices.put((String)countryCode, sortedSlices);
            } else {
                sortedSlices.addAll(slicesForCountry);
                processedSlices.put((String)countryCode, sortedSlices);
            }
        });
        return processedSlices;
    }

    private void processLineSlices(Line line, List<Geometry> slices, Atlas atlas, ChangeBuilder lineChanges) {
        CountrySlicingIdentifierFactory lineIdentifierFactory = new CountrySlicingIdentifierFactory(line.getIdentifier());
        PointIdentifierFactory pointIdentifierFactory = new PointIdentifierFactory(line.getIdentifier());
        slices.forEach(slice -> {
            org.locationtech.jts.geom.Polygon polygonForSlice;
            if (slice instanceof org.locationtech.jts.geom.Polygon && (polygonForSlice = (org.locationtech.jts.geom.Polygon)slice).getNumInteriorRing() > 0) {
                logger.warn("Line {} had a multipolygon result for slicing for Atlas {}!", (Object)line.getIdentifier(), (Object)this.getShardOrAtlasName());
            }
        });
        SortedMap<String, Collection<Geometry>> mergedSlices = this.preprocessSlices(slices);
        mergedSlices.keySet().forEach(countryCode -> {
            for (Geometry slice : (Collection)mergedSlices.get(countryCode)) {
                long lineSliceIdentifier = lineIdentifierFactory.nextIdentifier();
                PolyLine newLineGeometry = this.processSlice(slice, pointIdentifierFactory, line, atlas, lineChanges);
                Map<String, String> lineTags = RawAtlasPointAndLineSlicer.createLineTags(slice, line.getTags());
                CompleteLine newLineSlice = ((CompleteLine)CompleteLine.from(line).withIdentifier(lineSliceIdentifier).withTags(lineTags)).withPolyLine(newLineGeometry);
                if (!this.isInsideWorkingBound(newLineSlice)) continue;
                lineChanges.add(FeatureChange.add(newLineSlice, atlas));
                for (Relation relation : line.relations()) {
                    CompleteRelation updatedRelation = CompleteRelation.from(relation).withAddedMember((AtlasEntity)newLineSlice, line);
                    lineChanges.add(FeatureChange.add(updatedRelation, atlas));
                }
            }
        });
        lineChanges.add(FeatureChange.remove(CompleteLine.shallowFrom(line), atlas));
    }

    private PolyLine processSlice(Geometry slice, PointIdentifierFactory pointIdentifierFactory, Line line, Atlas atlas, ChangeBuilder lineChanges) {
        boolean sliceClockwise;
        boolean originalClockwise;
        Coordinate[] jtsSliceCoordinates;
        ArrayList<Location> slicedLineLocations = new ArrayList<Location>();
        for (Coordinate coordinate : jtsSliceCoordinates = PRECISION_REDUCER.edit(slice.getCoordinates(), slice)) {
            Location coordinateLocation = JTS_LOCATION_CONVERTER.backwardConvert(coordinate);
            if (Iterables.isEmpty(atlas.pointsAt(coordinateLocation))) {
                Location scaledLocation = JTS_LOCATION_CONVERTER.backwardConvert(this.getCoordinateToPointMapping().getScaledCoordinate(coordinate));
                slicedLineLocations.add(scaledLocation);
                if (!Iterables.isEmpty(atlas.pointsAt(scaledLocation)) || this.getCoordinateToPointMapping().containsCoordinate(coordinate)) continue;
                Map<String, String> pointTags = this.createPointTags(coordinateLocation, false);
                pointTags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
                long pointIdentifier = this.createNewPointIdentifier(pointIdentifierFactory, line.getIdentifier());
                CompletePoint newPointFromSlice = new CompletePoint(pointIdentifier, scaledLocation, pointTags, new HashSet<Long>());
                this.getCoordinateToPointMapping().storeMapping(coordinate, pointIdentifier);
                lineChanges.add(FeatureChange.add(newPointFromSlice, atlas));
                continue;
            }
            slicedLineLocations.add(coordinateLocation);
        }
        PolyLine polylineForSlice = new PolyLine((List<? extends Location>)slicedLineLocations);
        if (line.isClosed() && (originalClockwise = new Polygon(line.asPolyLine().truncate(0, 1)).isClockwise()) != (sliceClockwise = new Polygon(polylineForSlice.truncate(0, 1)).isClockwise())) {
            polylineForSlice = polylineForSlice.reversed();
        }
        return polylineForSlice;
    }

    private boolean relateCandidates(long identifier, List<org.locationtech.jts.geom.Polygon> candidates, Geometry target) {
        for (org.locationtech.jts.geom.Polygon candidate : candidates) {
            String countryCode = CountryBoundaryMap.getGeometryProperty(candidate, "iso_country_code");
            if (Strings.isNullOrEmpty(countryCode)) {
                logger.warn("Ignoring a candidate polygon from slicing way {}, because it is missing country tag.", (Object)identifier);
                continue;
            }
            try {
                IntersectionMatrix matrix = target.relate(candidate);
                if (!matrix.isWithin()) continue;
                CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", countryCode);
                return true;
            }
            catch (Exception e) {
                logger.warn("error slicing way {}:", (Object)identifier, (Object)e);
            }
        }
        return false;
    }

    private List<Geometry> sliceGeometry(Geometry geometry, Line line) {
        try {
            CountryBoundaryMap boundary = this.getCountryBoundaryMap();
            ArrayList<Geometry> results = new ArrayList<Geometry>();
            if (Objects.isNull(geometry)) {
                return results;
            }
            Geometry target = geometry;
            List<org.locationtech.jts.geom.Polygon> candidates = boundary.query(target.getEnvelopeInternal()).stream().distinct().collect(Collectors.toList());
            if (this.shouldSkipSlicing(candidates, line)) {
                String countryCode = CountryBoundaryMap.getGeometryProperty(candidates.get(0), "iso_country_code");
                CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", countryCode);
                return results;
            }
            long numberCountries = CountryBoundaryMap.numberCountries(candidates);
            if (numberCountries > 3L) {
                logger.warn("Slicing way {} with {} countries.", (Object)line.getIdentifier(), (Object)numberCountries);
            }
            if (this.relateCandidates(line.getIdentifier(), candidates, target)) {
                return results;
            }
            if (this.shouldSkipSlicing(candidates, line)) {
                String countryCode = CountryBoundaryMap.getGeometryProperty(candidates.get(0), "iso_country_code");
                CountryBoundaryMap.setGeometryProperty(target, "iso_country_code", countryCode);
                return results;
            }
            Collections.sort(candidates, (first, second) -> {
                int countryCodeComparison = CountryBoundaryMap.getGeometryProperty(first, "iso_country_code").compareTo(CountryBoundaryMap.getGeometryProperty(second, "iso_country_code"));
                if (countryCodeComparison != 0) {
                    return countryCodeComparison;
                }
                return first.compareTo(second);
            });
            Geometry remainder = this.cutGeometry(line.getIdentifier(), candidates, results, target);
            if (remainder == null) {
                return results;
            }
            Geometry nearestGeometry = boundary.nearestNeighbour(target.getEnvelopeInternal(), remainder, new GeometryItemDistance());
            if (nearestGeometry == null) {
                return results;
            }
            for (int i = 0; i < remainder.getNumGeometries(); ++i) {
                Geometry current = remainder.getGeometryN(i);
                if (!this.isSignificantGeometry(current)) continue;
                String nearestCountryCode = CountryBoundaryMap.getGeometryProperty(nearestGeometry, "iso_country_code");
                CountryBoundaryMap.setGeometryProperty(current, "iso_country_code", nearestCountryCode);
                CountryBoundaryMap.setGeometryProperty(current, "nearest_neighbor_country_code", SyntheticNearestNeighborCountryCodeTag.YES.toString());
                this.addResult(current, results);
            }
            return results;
        }
        catch (TopologyException e) {
            logger.error("Topology Exception when slicing Line {} for Atlas {}", new Object[]{line.getIdentifier(), this.getShardOrAtlasName(), e});
            return Collections.emptyList();
        }
    }

    private void sliceLine(Line line, Atlas atlas, ChangeBuilder lineChanges) {
        List<Geometry> slices = this.convertToJtsGeometryAndSlice(line);
        if (slices.isEmpty()) {
            CompleteLine updatedLine = (CompleteLine)((CompleteLine)CompleteLine.shallowFrom(line).withTags(line.getTags())).withAddedTag("iso_country_code", "N/A");
            lineChanges.add(FeatureChange.add(updatedLine, atlas));
        } else if (CountryBoundaryMap.isSameCountry(slices) && !this.shouldForceSlicing(line)) {
            CompleteLine updatedLine = (CompleteLine)CompleteLine.shallowFrom(line).withTags(RawAtlasPointAndLineSlicer.createLineTags(slices.get(0), line.getTags()));
            if (this.isInsideWorkingBound(updatedLine)) {
                lineChanges.add(FeatureChange.add(updatedLine, atlas));
            } else {
                lineChanges.add(FeatureChange.remove(CompleteLine.shallowFrom(line), atlas));
            }
        } else if ((long)slices.size() > 1000L) {
            logger.error("Country slicing exceeded maximum line identifier name space of {} for Line {} for Atlas {}. It will be added as is, with two or more country codes.", new Object[]{1000L, line.getIdentifier(), this.getShardOrAtlasName()});
            Set allCountries = slices.stream().map(geometry -> CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")).collect(Collectors.toCollection(TreeSet::new));
            String countryString = String.join((CharSequence)",", allCountries);
            CompleteLine afterLine = (CompleteLine)((CompleteLine)CompleteLine.shallowFrom(line).withTags(line.getTags())).withAddedTag("iso_country_code", countryString);
            lineChanges.add(FeatureChange.add(afterLine, atlas));
        } else {
            this.processLineSlices(line, slices, atlas, lineChanges);
        }
    }

    private Atlas sliceLines(Atlas pointSlicedAtlas) {
        ChangeBuilder lineChangeBuilder = new ChangeBuilder();
        StreamSupport.stream(pointSlicedAtlas.lines().spliterator(), true).forEach(line -> this.sliceLine((Line)line, pointSlicedAtlas, lineChangeBuilder));
        if (lineChangeBuilder.peekNumberOfChanges() == 0) {
            return pointSlicedAtlas;
        }
        return new ChangeAtlas(pointSlicedAtlas, lineChangeBuilder.get());
    }

    private Atlas slicePoints(Atlas lineSlicedAtlas) {
        ChangeBuilder pointChanges = new ChangeBuilder();
        StreamSupport.stream(lineSlicedAtlas.points().spliterator(), true).forEach(point -> {
            if (!point.getTag("iso_country_code").isPresent()) {
                CompletePoint afterPoint = (CompletePoint)CompletePoint.shallowFrom(point).withTags(point.getTags());
                this.createPointTags(point.getLocation(), true).forEach(afterPoint::withAddedTag);
                pointChanges.add(FeatureChange.add(afterPoint, lineSlicedAtlas));
            }
        });
        if (pointChanges.peekNumberOfChanges() == 0) {
            return lineSlicedAtlas;
        }
        return new ChangeAtlas(lineSlicedAtlas, pointChanges.get());
    }
}

