/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasPointAndLineSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasRelationSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasCountrySlicer {
    private static final String STARTED_TASK_MESSAGE = "Started {} for Shard {}";
    private static final String COMPLETED_TASK_MESSAGE = "Finished {} for Shard {} in {}";
    private static final String DYNAMIC_ATLAS_CREATION_TASK = "dynamic Atlas creation";
    private static final String POINT_AND_LINE_SLICING_TASK = "point and line slicing";
    private static final String RELATION_SLICING_TASK = "relation slicing";
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasCountrySlicer.class);
    private final Predicate<AtlasEntity> relationPredicate;
    private final Sharding sharding;
    private final Function<Shard, Optional<Atlas>> atlasFetcher;
    private final AtlasLoadingOption loadingOption;

    public RawAtlasCountrySlicer(AtlasLoadingOption loadingOption) {
        this.loadingOption = loadingOption;
        this.relationPredicate = entity -> entity.getType().equals((Object)ItemType.RELATION) && loadingOption.getRelationSlicingFilter().test((Taggable)entity);
        this.sharding = null;
        this.atlasFetcher = null;
    }

    public RawAtlasCountrySlicer(AtlasLoadingOption loadingOption, Sharding sharding, Function<Shard, Optional<Atlas>> atlasFetcher) {
        if (sharding == null || atlasFetcher == null) {
            throw new IllegalArgumentException("Must supply a valid sharding and fetcher function for slicing!");
        }
        this.loadingOption = loadingOption;
        this.relationPredicate = entity -> entity.getType().equals((Object)ItemType.RELATION) && loadingOption.getRelationSlicingFilter().test((Taggable)entity);
        this.sharding = sharding;
        this.atlasFetcher = atlasFetcher;
    }

    public AtlasLoadingOption getLoadingOption() {
        return this.loadingOption;
    }

    public Atlas slice(Atlas rawAtlas) {
        Atlas partiallySlicedAtlas = this.sliceLines(rawAtlas);
        return this.sliceRelations(partiallySlicedAtlas);
    }

    public Atlas sliceLines(Atlas rawAtlas) {
        Time time = Time.now();
        String shardName = this.getShardOrAtlasName(rawAtlas);
        logger.info(STARTED_TASK_MESSAGE, (Object)POINT_AND_LINE_SLICING_TASK, (Object)shardName);
        RawAtlasPointAndLineSlicer pointAndLineSlicer = new RawAtlasPointAndLineSlicer(rawAtlas, this.loadingOption);
        logger.info(COMPLETED_TASK_MESSAGE, new Object[]{POINT_AND_LINE_SLICING_TASK, shardName, time.elapsedSince()});
        return ((RawAtlasSlicer)pointAndLineSlicer).slice();
    }

    public Atlas sliceRelations(Atlas partiallySlicedAtlas) {
        Time time = Time.now();
        String shardName = this.getShardOrAtlasName(partiallySlicedAtlas);
        logger.info(STARTED_TASK_MESSAGE, (Object)RELATION_SLICING_TASK, (Object)shardName);
        RawAtlasRelationSlicer relationSlicer = new RawAtlasRelationSlicer(partiallySlicedAtlas, null, this.loadingOption);
        logger.info(COMPLETED_TASK_MESSAGE, new Object[]{RELATION_SLICING_TASK, shardName, time.elapsedSince()});
        return ((RawAtlasSlicer)relationSlicer).slice();
    }

    public Atlas sliceRelations(Shard initialShard) {
        Time time = Time.now();
        Atlas partiallySlicedExpandedAtlas = this.buildExpandedAtlas(initialShard);
        HashSet relationsForInitialShard = new HashSet();
        Optional<Atlas> initialShardOptional = this.atlasFetcher.apply(initialShard);
        if (!initialShardOptional.isPresent()) {
            throw new CoreException("Could not get data for initial shard {} during relation slicing!", initialShard.getName());
        }
        initialShardOptional.get().relations().forEach(relation -> relationsForInitialShard.add(relation.getIdentifier()));
        Predicate<AtlasEntity> filter = entity -> {
            if (entity.getType().equals((Object)ItemType.RELATION)) {
                return relationsForInitialShard.contains(entity.getIdentifier());
            }
            return true;
        };
        Optional<Atlas> subAtlasOptional = partiallySlicedExpandedAtlas.subAtlas(filter, AtlasCutType.SILK_CUT);
        if (subAtlasOptional.isPresent()) {
            Atlas partiallySlicedExpandedAtlasWithExtraRelationsRemoved = subAtlasOptional.get();
            String shardName = this.getShardOrAtlasName(partiallySlicedExpandedAtlasWithExtraRelationsRemoved);
            logger.info(STARTED_TASK_MESSAGE, (Object)RELATION_SLICING_TASK, (Object)shardName);
            RawAtlasRelationSlicer relationSlicer = new RawAtlasRelationSlicer(partiallySlicedExpandedAtlasWithExtraRelationsRemoved, initialShard, this.loadingOption);
            logger.info(COMPLETED_TASK_MESSAGE, new Object[]{RELATION_SLICING_TASK, shardName, time.elapsedSince()});
            return ((RawAtlasSlicer)relationSlicer).slice();
        }
        throw new CoreException("No data after sub-atlasing to remove new relations from partially expanded Atlas {}!", partiallySlicedExpandedAtlas.getName());
    }

    private Atlas buildExpandedAtlas(Shard initialShard) {
        Time dynamicAtlasTime = Time.now();
        logger.info(DYNAMIC_ATLAS_CREATION_TASK, (Object)initialShard.getName());
        DynamicAtlasPolicy policy = new DynamicAtlasPolicy(this.atlasFetcher, this.sharding, initialShard, (Polygon)Rectangle.MAXIMUM).withDeferredLoading(true).withExtendIndefinitely(false).withAggressivelyExploreRelations(true).withAtlasEntitiesToConsiderForExpansion(this.relationPredicate);
        DynamicAtlas atlas = new DynamicAtlas(policy);
        atlas.preemptiveLoad();
        logger.info(COMPLETED_TASK_MESSAGE, new Object[]{DYNAMIC_ATLAS_CREATION_TASK, initialShard.getName(), dynamicAtlasTime.elapsedSince()});
        return atlas;
    }

    private String getShardOrAtlasName(Atlas atlas) {
        return atlas.metaData().getShardName().orElse(atlas.getName());
    }
}

