/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.sectioning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.WaySectionIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.NodeOccurrenceCounter;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.PbfOneWay;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryEdge;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryNode;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.tags.AtlasTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.SyntheticInvalidWaySectionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class WaySectionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WaySectionProcessor.class);
    private static final int MINIMUM_NUMBER_OF_SELF_INTERSECTIONS_FOR_A_NODE = 3;
    private static final int MINIMUM_SHAPE_POINTS_TO_QUALIFY_AS_AREA = 3;
    private static final int MINIMUM_POINTS_TO_QUALIFY_AS_A_LINE = 2;
    private static final int SINGLE_SECTIONING_IDENTIFIER_REMAINING_DELTA = 998;
    private static final String STARTED_TASK_MESSAGE = "Started {} for Shard {}";
    private static final String COMPLETED_TASK_MESSAGE = "Finished {} for Shard {} in {}";
    private static final String RELATION_MEMBER_EXCLUSION_MESSAGE = "Excluding {} {} from Relation {} since this member is not in the Atlas";
    private static final String WAY_SECTIONING_TASK = "Way-Sectioning";
    private static final String EDGE_SECTIONING_TASK = "Edge Sectioning";
    private static final String SHAPE_POINT_DETECTION_TASK = "Shape Point Detection";
    private static final String DYNAMIC_ATLAS_CREATION_TASK = "Dynamic Atlas Creation";
    private static final String ATLAS_FEATURE_DETECTION_TASK = "Atlas Feature Detection";
    private static final String SECTIONED_ATLAS_CREATION_TASK = "Sectioned Atlas Creation";
    private static final Distance SHARD_EXPANSION_DISTANCE = Distance.meters(20.0);
    private final Atlas rawAtlas;
    private final AtlasLoadingOption loadingOption;
    private final List<Shard> loadedShards = new ArrayList<Shard>();
    private final Predicate<AtlasEntity> dynamicAtlasExpansionFilter = entity -> entity instanceof Line && this.isAtlasEdge((Line)entity);
    private final Atlas edgeOnlySubAtlas;

    public WaySectionProcessor(Atlas rawAtlas, AtlasLoadingOption loadingOption) {
        this.rawAtlas = rawAtlas;
        this.loadingOption = loadingOption;
        Optional<Atlas> edgeOnlySubAtlasOptional = rawAtlas.subAtlas(this.dynamicAtlasExpansionFilter, AtlasCutType.SILK_CUT);
        if (edgeOnlySubAtlasOptional.isPresent()) {
            logger.info("Cut subatlas for edges-only");
            this.edgeOnlySubAtlas = edgeOnlySubAtlasOptional.get();
        } else {
            this.edgeOnlySubAtlas = rawAtlas;
        }
    }

    public WaySectionProcessor(Shard initialShard, AtlasLoadingOption loadingOption, Sharding sharding, Function<Shard, Optional<Atlas>> rawAtlasFetcher) {
        this.loadingOption = loadingOption;
        if (sharding == null || rawAtlasFetcher == null) {
            throw new IllegalArgumentException("Must supply a valid sharding and fetcher function for sectioning!");
        }
        this.rawAtlas = this.buildExpandedAtlas(initialShard, sharding, rawAtlasFetcher);
        Optional<Atlas> edgeOnlySubAtlasOptional = this.rawAtlas.subAtlas(this.dynamicAtlasExpansionFilter, AtlasCutType.SILK_CUT);
        if (edgeOnlySubAtlasOptional.isPresent()) {
            logger.info("Cut subatlas for edges-only");
            this.edgeOnlySubAtlas = edgeOnlySubAtlasOptional.get();
        } else {
            this.edgeOnlySubAtlas = this.rawAtlas;
        }
    }

    public Atlas run() {
        Time time = this.logTaskStartedAsInfo(WAY_SECTIONING_TASK, this.getShardOrAtlasName());
        WaySectionChangeSet changeSet = new WaySectionChangeSet();
        this.identifyEdgesNodesAndAreasFromLines(changeSet);
        this.distinguishPointsFromShapePoints(changeSet);
        this.sectionEdges(changeSet);
        Atlas atlas = this.buildSectionedAtlas(changeSet);
        this.logTaskAsInfo(COMPLETED_TASK_MESSAGE, WAY_SECTIONING_TASK, this.getShardOrAtlasName(), time.elapsedSince());
        return this.cutSubAtlasForOriginalShard(atlas);
    }

    private void addPointToNodeList(Location location, NodeOccurrenceCounter nodeCounter) {
        this.rawAtlas.pointsAt(location).forEach(point -> nodeCounter.addNode(new TemporaryNode(point.getIdentifier(), point.getLocation())));
    }

    private Atlas buildExpandedAtlas(Shard initialShard, Sharding sharding, Function<Shard, Optional<Atlas>> fullySlicedAtlasFetcher) {
        Time dynamicAtlasTime = this.logTaskStartedAsInfo(DYNAMIC_ATLAS_CREATION_TASK, initialShard.getName());
        this.loadedShards.add(initialShard);
        DynamicAtlasPolicy policy = new DynamicAtlasPolicy(fullySlicedAtlasFetcher, sharding, initialShard.bounds().expand(SHARD_EXPANSION_DISTANCE), (Polygon)Rectangle.MAXIMUM).withDeferredLoading(true).withExtendIndefinitely(false).withAtlasEntitiesToConsiderForExpansion(this.dynamicAtlasExpansionFilter::test);
        DynamicAtlas atlas = new DynamicAtlas(policy);
        atlas.preemptiveLoad();
        this.logTaskAsInfo(COMPLETED_TASK_MESSAGE, DYNAMIC_ATLAS_CREATION_TASK, this.getShardOrAtlasName(), dynamicAtlasTime.elapsedSince());
        return atlas;
    }

    private Atlas buildSectionedAtlas(WaySectionChangeSet changeSet) {
        Time buildTime = this.logTaskStartedAsInfo(SECTIONED_ATLAS_CREATION_TASK, this.getShardOrAtlasName());
        PackedAtlasBuilder builder = new PackedAtlasBuilder();
        AtlasSize sizeEstimate = this.createAtlasSizeEstimate(changeSet);
        builder.setSizeEstimates(sizeEstimate);
        builder.setMetaData(this.createAtlasMetadata());
        changeSet.getPointsThatStayPoints().forEach(pointIdentifier -> {
            Point point = this.rawAtlas.point((long)pointIdentifier);
            builder.addPoint((long)pointIdentifier, point.getLocation(), point.getTags());
        });
        changeSet.getPointsThatBecomeNodes().forEach(nodeIdentifier -> {
            Point point = this.rawAtlas.point((long)nodeIdentifier);
            builder.addNode(point.getIdentifier(), point.getLocation(), point.getTags());
        });
        Iterables.stream(this.rawAtlas.lines()).filter(line -> {
            long lineIdentifier = line.getIdentifier();
            return !changeSet.getLinesThatBecomeAreas().contains(lineIdentifier) && !changeSet.getLinesThatBecomeEdges().contains(lineIdentifier) && !changeSet.getExcludedLines().contains(lineIdentifier);
        }).forEach(lineToKeep -> builder.addLine(lineToKeep.getIdentifier(), lineToKeep.asPolyLine(), lineToKeep.getTags()));
        changeSet.getCreatedEdges().forEach(temporaryEdge -> {
            builder.addEdge(temporaryEdge.getIdentifier(), temporaryEdge.getPolyLine(), temporaryEdge.getTags());
            if (temporaryEdge.hasReverse()) {
                builder.addEdge(temporaryEdge.getReverseEdgeIdentifier(), temporaryEdge.getPolyLine().reversed(), temporaryEdge.getTags());
            }
        });
        changeSet.getLinesThatBecomeAreas().forEach(areaIdentifier -> {
            Line line = this.rawAtlas.line((long)areaIdentifier);
            builder.addArea((long)areaIdentifier, new Polygon(line.asPolyLine().truncate(0, 1)), line.getTags());
        });
        this.rawAtlas.relationsLowerOrderFirst().forEach(relation -> {
            RelationBean bean = new RelationBean();
            relation.members().forEach(member -> {
                AtlasEntity entity = member.getEntity();
                long memberIdentifier = entity.getIdentifier();
                String memberRole = member.getRole();
                switch (entity.getType()) {
                    case POINT: {
                        boolean nodeExists;
                        boolean pointExists = builder.peek().point(memberIdentifier) != null;
                        boolean bl = nodeExists = builder.peek().node(memberIdentifier) != null;
                        if (pointExists) {
                            bean.addItem(memberIdentifier, memberRole, ItemType.POINT);
                        }
                        if (nodeExists) {
                            bean.addItem(memberIdentifier, memberRole, ItemType.NODE);
                        }
                        if (pointExists || nodeExists) break;
                        logger.debug(RELATION_MEMBER_EXCLUSION_MESSAGE, new Object[]{ItemType.POINT, memberIdentifier, relation.getIdentifier()});
                        break;
                    }
                    case LINE: {
                        if (changeSet.getLineToCreatedEdgesMapping().containsKey(memberIdentifier)) {
                            changeSet.getLineToCreatedEdgesMapping().get(memberIdentifier).forEach(edge -> {
                                bean.addItem(edge.getIdentifier(), memberRole, ItemType.EDGE);
                                if (edge.hasReverse()) {
                                    bean.addItem(edge.getReverseEdgeIdentifier(), memberRole, ItemType.EDGE);
                                }
                            });
                            break;
                        }
                        if (builder.peek().area(memberIdentifier) != null) {
                            bean.addItem(memberIdentifier, memberRole, ItemType.AREA);
                            break;
                        }
                        if (builder.peek().line(memberIdentifier) != null) {
                            bean.addItem(memberIdentifier, memberRole, ItemType.LINE);
                            break;
                        }
                        logger.debug(RELATION_MEMBER_EXCLUSION_MESSAGE, new Object[]{ItemType.LINE, memberIdentifier, relation.getIdentifier()});
                        break;
                    }
                    case RELATION: {
                        if (builder.peek().relation(memberIdentifier) != null) {
                            bean.addItem(memberIdentifier, memberRole, ItemType.RELATION);
                            break;
                        }
                        logger.debug(RELATION_MEMBER_EXCLUSION_MESSAGE, new Object[]{ItemType.RELATION, memberIdentifier, relation.getIdentifier()});
                        break;
                    }
                    default: {
                        throw new CoreException("Unsupported relation member type in Raw Atlas, {}", new Object[]{member.getEntity().getType()});
                    }
                }
            });
            if (!bean.isEmpty()) {
                builder.addRelation(relation.getIdentifier(), relation.getOsmIdentifier(), bean, relation.getTags());
            } else {
                logger.debug("Relation {} bean is empty, dropping from Atlas", (Object)relation.getIdentifier());
            }
        });
        this.logTaskAsInfo(COMPLETED_TASK_MESSAGE, SECTIONED_ATLAS_CREATION_TASK, this.getShardOrAtlasName(), buildTime.elapsedSince());
        return builder.get();
    }

    private AtlasMetaData createAtlasMetadata() {
        AtlasMetaData metadata = this.rawAtlas.metaData();
        metadata.getTags().put("edgeConfiguration", this.loadingOption.getEdgeFilter().toString());
        metadata.getTags().put("areaConfiguration", this.loadingOption.getAreaFilter().toString());
        metadata.getTags().put("waySectioningConfiguration", this.loadingOption.getWaySectionFilter().toString());
        return metadata;
    }

    private AtlasSize createAtlasSizeEstimate(WaySectionChangeSet changeSet) {
        int numberOfAreas = changeSet.getLinesThatBecomeAreas().size();
        int numberOfEdges = 0;
        for (TemporaryEdge edge : changeSet.getCreatedEdges()) {
            if (edge.hasReverse()) {
                numberOfEdges += 2;
                continue;
            }
            ++numberOfEdges;
        }
        long numberOfLines = this.rawAtlas.numberOfLines() - (long)(numberOfAreas + changeSet.getLineToCreatedEdgesMapping().keySet().size());
        return new AtlasSize(numberOfEdges, changeSet.getPointsThatBecomeNodes().size(), numberOfAreas, numberOfLines, changeSet.getPointsThatStayPoints().size(), this.rawAtlas.numberOfRelations());
    }

    private void createEdgeFromRemainingPolyline(Line line, int startIndex, boolean isReversed, boolean hasReverseEdge, WaySectionIdentifierFactory identifierFactory, List<TemporaryEdge> newEdgesForLine) {
        PolyLine polyline = line.asPolyLine();
        PolyLine rawPolyLine = new PolyLine(polyline.truncate(startIndex, 0));
        PolyLine edgePolyLine = isReversed ? rawPolyLine.reversed() : rawPolyLine;
        long edgeIdentifier = identifierFactory.nextIdentifier();
        Map<String, String> tags = line.getTags();
        tags.put("synthetic_invalid_way_section", SyntheticInvalidWaySectionTag.YES.toString());
        newEdgesForLine.add(new TemporaryEdge(edgeIdentifier, edgePolyLine, tags, hasReverseEdge));
    }

    private Atlas cutSubAtlasForOriginalShard(Atlas atlas) {
        try {
            if (!this.loadedShards.isEmpty()) {
                Rectangle originalShardBounds = this.loadedShards.get(0).bounds();
                return atlas.subAtlas(originalShardBounds, AtlasCutType.SOFT_CUT).orElseThrow(() -> new CoreException("Cannot have an empty atlas after way sectioning {}", this.loadedShards.get(0).getName()));
            }
            return atlas;
        }
        catch (Exception e) {
            throw new CoreException("Error creating sub-atlas for original shard bounds", e);
        }
    }

    private void distinguishPointsFromShapePoints(WaySectionChangeSet changeSet) {
        Time time = this.logTaskStartedAsInfo(SHAPE_POINT_DETECTION_TASK, this.getShardOrAtlasName());
        StreamSupport.stream(this.rawAtlas.points().spliterator(), true).filter(point -> this.isAtlasPoint(changeSet, (Point)point)).forEach(changeSet::recordPoint);
        this.logTaskAsInfo(COMPLETED_TASK_MESSAGE, SHAPE_POINT_DETECTION_TASK, this.getShardOrAtlasName(), time.elapsedSince());
    }

    private String getShardOrAtlasName() {
        if (!this.loadedShards.isEmpty()) {
            return this.loadedShards.get(0).getName();
        }
        return this.rawAtlas.getName();
    }

    private void identifyEdgesNodesAndAreasFromLines(WaySectionChangeSet changeSet) {
        Time time = this.logTaskStartedAsInfo(ATLAS_FEATURE_DETECTION_TASK, this.getShardOrAtlasName());
        StreamSupport.stream(this.rawAtlas.lines().spliterator(), true).forEach(line -> {
            boolean kept = false;
            if (this.isAtlasEdge((Line)line)) {
                NodeOccurrenceCounter nodesForEdge = new NodeOccurrenceCounter();
                PolyLine polyLine = line.asPolyLine();
                Set<Location> selfIntersections = polyLine.selfIntersections();
                if (line.isClosed() && polyLine.withoutDuplicateConsecutiveShapePoints().occurrences(polyLine.first()) < 3) {
                    selfIntersections.remove(polyLine.first());
                }
                for (int index = 0; index < polyLine.size(); ++index) {
                    Location shapePoint = polyLine.get(index);
                    if (selfIntersections.contains(shapePoint)) {
                        this.addPointToNodeList(shapePoint, nodesForEdge);
                        continue;
                    }
                    if (this.shouldSectionAtLocation(shapePoint)) {
                        this.addPointToNodeList(shapePoint, nodesForEdge);
                        continue;
                    }
                    if (this.locationIsPartOfAnIntersectingEdgeOfTheSameLayer(shapePoint, (Line)line)) {
                        this.addPointToNodeList(shapePoint, nodesForEdge);
                    }
                    if (!this.locationIsAnEndPointOfAnIntersectingEdgeOfDifferentLayer(shapePoint, (Line)line)) continue;
                    this.addPointToNodeList(shapePoint, nodesForEdge);
                }
                if (line.isClosed() && nodesForEdge.size() == 0) {
                    this.addPointToNodeList(polyLine.first(), nodesForEdge);
                    this.addPointToNodeList(polyLine.get(polyLine.size() / 2), nodesForEdge);
                } else if (!line.isClosed()) {
                    this.addPointToNodeList(polyLine.first(), nodesForEdge);
                    this.addPointToNodeList(polyLine.last(), nodesForEdge);
                }
                changeSet.createEdgeToNodeMapping(line.getIdentifier(), nodesForEdge);
                kept = true;
            }
            if (this.isAtlasArea((Line)line)) {
                changeSet.recordArea((Line)line);
                kept = true;
            }
            if (this.isAtlasLine((Line)line)) {
                kept = true;
            }
            if (!kept) {
                changeSet.recordExcludedLine((Line)line);
                logger.debug("Excluding line {} from Atlas, it's not defined by an Atlas edge, area or line", (Object)line.getIdentifier());
            }
        });
        this.logTaskAsInfo(COMPLETED_TASK_MESSAGE, ATLAS_FEATURE_DETECTION_TASK, this.getShardOrAtlasName(), time.elapsedSince());
    }

    private boolean isAtlasArea(Line line) {
        return line.isClosed() && this.qualifiesAsArea(line) && this.loadingOption.getAreaFilter().test(line);
    }

    private boolean isAtlasEdge(Line line) {
        return this.loadingOption.getEdgeFilter().test(line);
    }

    private boolean isAtlasLine(Line line) {
        return !this.isAtlasEdge(line) && (!line.isClosed() || line.numberOfShapePoints() == 1);
    }

    private boolean isAtlasNode(WaySectionChangeSet changeSet, Point point) {
        return changeSet.getPointsThatBecomeNodes().contains(point.getIdentifier());
    }

    private boolean isAtlasPoint(WaySectionChangeSet changeSet, Point point) {
        boolean isRelationMember;
        boolean hasExplicitOsmTags = this.pointHasExplicitOsmTags(point);
        if (hasExplicitOsmTags) {
            return true;
        }
        boolean bl = isRelationMember = !point.relations().isEmpty();
        if (isRelationMember && !this.isAtlasNode(changeSet, point)) {
            return true;
        }
        boolean isIsolatedNode = Iterables.isEmpty(this.rawAtlas.linesContaining(point.getLocation()));
        return !isRelationMember && isIsolatedNode;
    }

    private boolean locationIsAnEndPointOfAnIntersectingEdgeOfDifferentLayer(Location location, Line line) {
        long targetLayerValue = LayerTag.getTaggedOrImpliedValue(line, 0L);
        return Iterables.stream(this.edgeOnlySubAtlas.linesContaining(location, target -> target.getIdentifier() != line.getIdentifier() && target.asPolyLine().contains(location))).anyMatch(candidate -> {
            long layerValue = LayerTag.getTaggedOrImpliedValue(candidate, 0L);
            boolean edgesOnDifferentLayers = targetLayerValue != layerValue;
            PolyLine candidatePolyline = candidate.asPolyLine();
            boolean intersectionIsAtEndPoint = candidatePolyline.first().equals(location) || candidatePolyline.last().equals(location);
            return edgesOnDifferentLayers && intersectionIsAtEndPoint;
        });
    }

    private boolean locationIsPartOfAnIntersectingEdgeOfTheSameLayer(Location location, Line line) {
        long targetLayerValue = LayerTag.getTaggedOrImpliedValue(line, 0L);
        return Iterables.stream(this.edgeOnlySubAtlas.linesContaining(location, target -> target.getIdentifier() != line.getIdentifier() && target.asPolyLine().contains(location))).anyMatch(candidate -> {
            long layerValue = LayerTag.getTaggedOrImpliedValue(candidate, 0L);
            return targetLayerValue == layerValue;
        });
    }

    private void logTaskAsInfo(String message, Object ... arguments) {
        logger.info(MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage());
    }

    private Time logTaskStartedAsInfo(String taskname, String shardName) {
        Time time = Time.now();
        logger.info(STARTED_TASK_MESSAGE, (Object)taskname, (Object)shardName);
        return time;
    }

    private boolean pointHasExplicitOsmTags(Point point) {
        int osmAndAtlasTagCount;
        int pointTagSize = point.getTags().size();
        if (pointTagSize > AtlasTag.TAGS_FROM_OSM.size()) {
            int atlasTagCounter = 0;
            for (String tag : point.getTags().keySet()) {
                if (!AtlasTag.TAGS_FROM_ATLAS.contains(tag)) continue;
                ++atlasTagCounter;
            }
            osmAndAtlasTagCount = AtlasTag.TAGS_FROM_OSM.size() + atlasTagCounter;
        } else {
            osmAndAtlasTagCount = pointTagSize < AtlasTag.TAGS_FROM_OSM.size() ? pointTagSize : AtlasTag.TAGS_FROM_OSM.size();
        }
        return pointTagSize > osmAndAtlasTagCount;
    }

    private boolean qualifiesAsArea(Line line) {
        return line.numberOfShapePoints() > 3;
    }

    private void sectionEdges(WaySectionChangeSet changeSet) {
        Time sectionTime = this.logTaskStartedAsInfo(EDGE_SECTIONING_TASK, this.getShardOrAtlasName());
        changeSet.getLinesThatBecomeEdges().forEach(lineIdentifier -> {
            Line line = this.rawAtlas.line((long)lineIdentifier);
            List<TemporaryEdge> edges = line.isClosed() ? this.splitRingLineIntoEdges(changeSet, line) : this.splitNonRingLineIntoEdges(changeSet, line);
            changeSet.createLineToEdgeMapping(line, edges);
        });
        this.logTaskAsInfo(COMPLETED_TASK_MESSAGE, EDGE_SECTIONING_TASK, this.getShardOrAtlasName(), sectionTime.elapsedSince());
    }

    private boolean shouldSectionAtLocation(Location location) {
        return Iterables.stream(this.rawAtlas.pointsAt(location)).anyMatch(point -> this.loadingOption.getWaySectionFilter().test((Taggable)point));
    }

    private List<TemporaryEdge> splitNonRingLineIntoEdges(WaySectionChangeSet changeSet, Line line) {
        ArrayList<TemporaryEdge> newEdgesForLine = new ArrayList<TemporaryEdge>();
        PolyLine polyline = line.asPolyLine();
        if (polyline.size() < 2) {
            logger.error("Line {} hass less than {} points, cannot be sectioned!", (Object)line.getIdentifier(), (Object)2);
            return newEdgesForLine;
        }
        NodeOccurrenceCounter nodesToSectionAt = changeSet.getNodesForEdge(line);
        WaySectionIdentifierFactory identifierFactory = new WaySectionIdentifierFactory(line.getIdentifier());
        PbfOneWay oneWay = PbfOneWay.forTag(line);
        boolean hasReverseEdge = oneWay == PbfOneWay.NO;
        boolean isReversed = oneWay == PbfOneWay.REVERSED;
        Optional<Object> startNode = Optional.empty();
        Optional<Object> endNode = Optional.empty();
        try {
            int startIndex = 0;
            startNode = nodesToSectionAt.getNode(polyline.first());
            if (!startNode.isPresent()) {
                logger.error("Can't find starting Node for Line {} during way-sectioning. Aborting!", (Object)line.getIdentifier());
                return newEdgesForLine;
            }
            HashMap<Long, Integer> duplicateLocations = new HashMap<Long, Integer>();
            for (int index = 1; index < polyline.size(); ++index) {
                if (identifierFactory.getDelta() == 998L) {
                    this.createEdgeFromRemainingPolyline(line, startIndex, isReversed, hasReverseEdge, identifierFactory, newEdgesForLine);
                    break;
                }
                endNode = nodesToSectionAt.getNode(polyline.get(index));
                if (!endNode.isPresent()) continue;
                TemporaryNode end = (TemporaryNode)endNode.get();
                if (end.equals(startNode.get()) && polyline.get(index).equals(polyline.get(index - 1))) {
                    long startIdentifier = ((TemporaryNode)startNode.get()).getIdentifier();
                    int duplicateCount = duplicateLocations.containsKey(startIdentifier) ? (Integer)duplicateLocations.get(startIdentifier) : 0;
                    duplicateLocations.put(startIdentifier, duplicateCount + 1);
                    continue;
                }
                int startOccurrence = nodesToSectionAt.getOccurrence((TemporaryNode)startNode.get()) - 1;
                nodesToSectionAt.incrementOccurrence((TemporaryNode)startNode.get());
                int endOccurrence = duplicateLocations.getOrDefault(end.getIdentifier(), 0) + nodesToSectionAt.getOccurrence(end) - 1;
                PolyLine rawPolyline = polyline.between(polyline.get(startIndex), startOccurrence, polyline.get(index), endOccurrence);
                PolyLine edgePolyline = isReversed ? rawPolyline.reversed() : rawPolyline;
                long edgeIdentifier = !line.isClosed() && nodesToSectionAt.size() == 2 && polyline.size() - 1 == index && newEdgesForLine.isEmpty() ? line.getIdentifier() : identifierFactory.nextIdentifier();
                newEdgesForLine.add(new TemporaryEdge(edgeIdentifier, edgePolyline, line.getTags(), hasReverseEdge));
                startIndex = index;
                startNode = endNode;
            }
        }
        catch (Exception e) {
            throw new CoreException("Failed to way-section line {}", line.getIdentifier(), e);
        }
        return newEdgesForLine;
    }

    private List<TemporaryEdge> splitRingLineIntoEdges(WaySectionChangeSet changeSet, Line line) {
        ArrayList<TemporaryEdge> newEdgesForLine = new ArrayList<TemporaryEdge>();
        PolyLine polyline = line.asPolyLine();
        if (polyline.size() < 2) {
            logger.error("Line {} hass less than {} points, cannot be sectioned!", (Object)line.getIdentifier(), (Object)2);
            return newEdgesForLine;
        }
        NodeOccurrenceCounter nodesToSectionAt = changeSet.getNodesForEdge(line);
        WaySectionIdentifierFactory identifierFactory = new WaySectionIdentifierFactory(line.getIdentifier());
        PbfOneWay oneWay = PbfOneWay.forTag(line);
        boolean hasReverseEdge = oneWay == PbfOneWay.NO;
        boolean isReversed = oneWay == PbfOneWay.REVERSED;
        int startIndex = 0;
        PolyLine polyLineUpToFirstNode = null;
        boolean isFirstNode = true;
        Optional<Object> startNode = Optional.empty();
        Optional<Object> endNode = Optional.empty();
        try {
            startNode = nodesToSectionAt.getNode(polyline.first());
            if (startNode.isPresent()) {
                return this.splitNonRingLineIntoEdges(changeSet, line);
            }
            HashMap<Location, Integer> duplicateLocations = new HashMap<Location, Integer>();
            duplicateLocations.put(polyline.first(), 1);
            for (int index = 1; index < polyline.size(); ++index) {
                Location currentLocation = polyline.get(index);
                endNode = nodesToSectionAt.getNode(currentLocation);
                if (!endNode.isPresent() && !startNode.isPresent()) {
                    int duplicateCount = duplicateLocations.containsKey(currentLocation) ? (Integer)duplicateLocations.get(currentLocation) : 0;
                    duplicateLocations.put(currentLocation, duplicateCount + 1);
                }
                if (identifierFactory.getDelta() == 998L) {
                    this.createEdgeFromRemainingPolyline(line, startIndex, isReversed, hasReverseEdge, identifierFactory, newEdgesForLine);
                    break;
                }
                if (endNode.isPresent()) {
                    TemporaryNode end = (TemporaryNode)endNode.get();
                    if (!isFirstNode) {
                        if (end.equals(startNode.get()) && polyline.get(index).equals(polyline.get(index - 1))) {
                            int duplicateCount = duplicateLocations.containsKey(currentLocation) ? (Integer)duplicateLocations.get(currentLocation) : 0;
                            duplicateLocations.put(currentLocation, duplicateCount + 1);
                            continue;
                        }
                        int startOccurrence = nodesToSectionAt.getOccurrence((TemporaryNode)startNode.get()) - 1;
                        nodesToSectionAt.incrementOccurrence((TemporaryNode)startNode.get());
                        int endOccurrence = duplicateLocations.getOrDefault(currentLocation, 0) + nodesToSectionAt.getOccurrence(end) - 1;
                        PolyLine rawPolyline = polyline.between(polyline.get(startIndex), startOccurrence, polyline.get(index), endOccurrence);
                        PolyLine edgePolyline = isReversed ? rawPolyline.reversed() : rawPolyline;
                        newEdgesForLine.add(new TemporaryEdge(identifierFactory.nextIdentifier(), edgePolyline, line.getTags(), hasReverseEdge));
                    }
                    startIndex = index;
                    startNode = endNode;
                    if (isFirstNode) {
                        PolyLine rawPolyline = polyline.between(polyline.first(), 0, polyline.get(index), 0);
                        polyLineUpToFirstNode = isReversed ? rawPolyline.reversed() : rawPolyline;
                        isFirstNode = false;
                    }
                }
                if (index != polyline.size() - 1) continue;
                if (polyLineUpToFirstNode == null) {
                    throw new CoreException("Cannot section ring {} - reached end of ring without valid end node", line.getIdentifier());
                }
                int endOccurrence = duplicateLocations.containsKey(currentLocation) ? (Integer)duplicateLocations.get(currentLocation) : 1;
                PolyLine rawPolylineFromLastNodeToLastLocation = polyline.between(polyline.get(startIndex), nodesToSectionAt.getOccurrence((TemporaryNode)startNode.get()) - 1, currentLocation, endOccurrence);
                PolyLine edgePolyLine = isReversed ? polyLineUpToFirstNode.append(rawPolylineFromLastNodeToLastLocation.reversed()) : rawPolylineFromLastNodeToLastLocation.append(polyLineUpToFirstNode);
                TemporaryEdge edge = new TemporaryEdge(identifierFactory.nextIdentifier(), edgePolyLine, line.getTags(), hasReverseEdge);
                newEdgesForLine.add(edge);
            }
        }
        catch (Exception e) {
            throw new CoreException("Failed to way-section line {}", line.getIdentifier(), e);
        }
        return newEdgesForLine;
    }
}

