/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.sectioning;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.NodeOccurrenceCounter;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryEdge;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryNode;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class WaySectionChangeSet {
    private final Set<Long> linesToBecomeAreas = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Long> linesExcludedFromAtlas = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Long> pointsToStayPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Long> pointsToBecomesNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Long, NodeOccurrenceCounter> edgeToNodeMapping = new ConcurrentHashMap<Long, NodeOccurrenceCounter>();
    private final MultiMap<Long, TemporaryEdge> lineToEdgeMapping = new MultiMap();

    public void createEdgeToNodeMapping(long edgeIdentifier, NodeOccurrenceCounter nodes) {
        this.edgeToNodeMapping.put(edgeIdentifier, nodes);
    }

    public void createLineToEdgeMapping(Line line, List<TemporaryEdge> edges) {
        this.lineToEdgeMapping.put((Long)line.getIdentifier(), edges);
    }

    public List<TemporaryEdge> getCreatedEdges() {
        return this.lineToEdgeMapping.allValues();
    }

    public Set<Long> getExcludedLines() {
        return this.linesExcludedFromAtlas;
    }

    public MultiMap<Long, TemporaryEdge> getLineToCreatedEdgesMapping() {
        return this.lineToEdgeMapping;
    }

    public Set<Long> getLinesThatBecomeAreas() {
        return this.linesToBecomeAreas;
    }

    public Set<Long> getLinesThatBecomeEdges() {
        return this.edgeToNodeMapping.keySet();
    }

    public NodeOccurrenceCounter getNodesForEdge(Line line) {
        return this.edgeToNodeMapping.get(line.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getPointsThatBecomeNodes() {
        WaySectionChangeSet waySectionChangeSet = this;
        synchronized (waySectionChangeSet) {
            if (this.pointsToBecomesNodes.isEmpty()) {
                this.pointsToBecomesNodes.addAll(this.edgeToNodeMapping.values().stream().flatMap(mapping -> mapping.getNodes().stream()).map(TemporaryNode::getIdentifier).collect(Collectors.toSet()));
            }
        }
        return this.pointsToBecomesNodes;
    }

    public Set<Long> getPointsThatStayPoints() {
        return this.pointsToStayPoints;
    }

    public void recordArea(Line line) {
        this.linesToBecomeAreas.add(line.getIdentifier());
    }

    public void recordExcludedLine(Line line) {
        this.linesExcludedFromAtlas.add(line.getIdentifier());
    }

    public void recordPoint(Point point) {
        this.pointsToStayPoints.add(point.getIdentifier());
    }
}

