/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.creation;

import java.util.function.Consumer;
import org.openstreetmap.atlas.utilities.statistic.storeless.CounterWithStatistic;
import org.slf4j.Logger;

public class RawAtlasStatistic {
    private static final long LOG_FREQUENCY = 10000L;
    private final Logger logger;
    private final CounterWithStatistic points;
    private final CounterWithStatistic lines;
    private final CounterWithStatistic relations;
    private final CounterWithStatistic filteredNodes;
    private final CounterWithStatistic filteredWays;
    private final CounterWithStatistic filteredRelations;
    private final CounterWithStatistic droppedWays;
    private final CounterWithStatistic droppedRelations;

    public RawAtlasStatistic(Logger logger) {
        this.logger = logger;
        Consumer<String> log = arg_0 -> ((Logger)logger).info(arg_0);
        this.points = new CounterWithStatistic(this.logger, 10000L, "Added Point");
        this.points.logUsingLevel(log);
        this.lines = new CounterWithStatistic(this.logger, 10000L, "Added Line");
        this.lines.logUsingLevel(log);
        this.relations = new CounterWithStatistic(this.logger, 10000L, "Added Relation");
        this.relations.logUsingLevel(log);
        this.filteredNodes = new CounterWithStatistic(this.logger, 10000L, "Filtered Node");
        this.filteredNodes.logUsingLevel(log);
        this.filteredWays = new CounterWithStatistic(this.logger, 10000L, "Filtered Way");
        this.filteredWays.logUsingLevel(log);
        this.filteredRelations = new CounterWithStatistic(this.logger, 10000L, "Filtered Relation");
        this.filteredRelations.logUsingLevel(log);
        this.droppedWays = new CounterWithStatistic(this.logger, 10000L, "Dropped Way");
        this.droppedWays.logUsingLevel(log);
        this.droppedRelations = new CounterWithStatistic(this.logger, 10000L, "Dropped Relation");
        this.droppedRelations.logUsingLevel(log);
    }

    public void recordCreatedLine() {
        this.lines.increment();
    }

    public void recordCreatedPoint() {
        this.points.increment();
    }

    public void recordCreatedRelation() {
        this.relations.increment();
    }

    public void recordDroppedRelation() {
        this.droppedRelations.increment();
    }

    public void recordDroppedWay() {
        this.droppedWays.increment();
    }

    public void recordFilteredNode() {
        this.filteredNodes.increment();
    }

    public void recordFilteredRelation() {
        this.filteredRelations.increment();
    }

    public void recordFilteredWay() {
        this.filteredWays.increment();
    }

    public void summary() {
        this.logger.trace("PBF to Raw Atlas Summary");
        this.points.summaryWithoutTimer();
        this.lines.summaryWithoutTimer();
        this.relations.summaryWithoutTimer();
        this.filteredNodes.summaryWithoutTimer();
        this.filteredWays.summaryWithoutTimer();
        this.filteredRelations.summaryWithoutTimer();
        this.droppedWays.summaryWithoutTimer();
        this.droppedRelations.summaryWithoutTimer();
    }
}

