/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.pbf;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;

public final class AtlasLoadingOption
implements Serializable {
    private static final long serialVersionUID = 1811691207451027561L;
    private static final ConfiguredTaggableFilter DEFAULT_EDGE_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("atlas-edge.json"))));
    private static final ConfiguredTaggableFilter DEFAULT_AREA_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("atlas-area.json"))));
    private static final ConfiguredTaggableFilter DEFAULT_RELATION_SLICING_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("atlas-relation-slicing.json"))));
    private static final ConfiguredTaggableFilter DEFAULT_WAY_SECTION_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("atlas-way-section.json"))));
    private static final ConfiguredTaggableFilter DEFAULT_OSM_PBF_WAY_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("osm-pbf-way.json"))));
    private static final ConfiguredTaggableFilter DEFAULT_OSM_PBF_NODE_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("osm-pbf-node.json"))));
    private static final ConfiguredTaggableFilter DEFAULT_OSM_PBF_RELATION_FILTER = new ConfiguredTaggableFilter(new StandardConfiguration(new InputStreamResource(() -> AtlasLoadingOption.class.getResourceAsStream("osm-pbf-relation.json"))));
    private boolean loadAtlasPoint = true;
    private boolean loadAtlasLine = true;
    private boolean loadAtlasArea = true;
    private boolean loadAtlasNode = true;
    private boolean loadAtlasEdge = true;
    private ConfiguredTaggableFilter edgeFilter = DEFAULT_EDGE_FILTER;
    private ConfiguredTaggableFilter areaFilter = DEFAULT_AREA_FILTER;
    private ConfiguredTaggableFilter waySectionFilter = DEFAULT_WAY_SECTION_FILTER;
    private ConfiguredTaggableFilter osmPbfWayFilter = DEFAULT_OSM_PBF_WAY_FILTER;
    private ConfiguredTaggableFilter osmPbfNodeFilter = DEFAULT_OSM_PBF_NODE_FILTER;
    private ConfiguredTaggableFilter osmPbfRelationFilter = DEFAULT_OSM_PBF_RELATION_FILTER;
    private ConfiguredTaggableFilter relationSlicingFilter = DEFAULT_RELATION_SLICING_FILTER;
    private ConfiguredTaggableFilter forceSlicingFilter = null;
    private boolean loadAtlasRelation = true;
    private boolean loadOsmBound = true;
    private boolean countrySlicing = false;
    private boolean waySectioning = false;
    private boolean loadWaysSpanningCountryBoundaries = true;
    private final Set<String> countryCodes = new HashSet<String>();
    private CountryBoundaryMap countryBoundaryMap = null;

    public static AtlasLoadingOption createOptionWithAllEnabled(CountryBoundaryMap countryBoundaryMap) {
        AtlasLoadingOption option = new AtlasLoadingOption();
        option.setCountrySlicing(true);
        option.setWaySectioning(true);
        option.setCountryBoundaryMap(countryBoundaryMap);
        return option;
    }

    public static AtlasLoadingOption createOptionWithNoSlicing() {
        return new AtlasLoadingOption();
    }

    public static AtlasLoadingOption createOptionWithOnlyNodesAndWayNoSlicing() {
        AtlasLoadingOption option = new AtlasLoadingOption();
        option.setLoadAtlasPoint(false);
        option.setLoadAtlasLine(false);
        option.setLoadAtlasArea(false);
        option.setLoadAtlasRelation(false);
        return option;
    }

    public static AtlasLoadingOption createOptionWithOnlyNodesAndWaysAndSlicing(CountryBoundaryMap countryBoundaryMap) {
        AtlasLoadingOption option = new AtlasLoadingOption();
        option.setLoadAtlasPoint(false);
        option.setLoadAtlasLine(false);
        option.setLoadAtlasArea(false);
        option.setLoadAtlasRelation(false);
        option.setCountrySlicing(true);
        option.setWaySectioning(true);
        option.setCountryBoundaryMap(countryBoundaryMap);
        return option;
    }

    public static AtlasLoadingOption createOptionWithOnlySectioning() {
        AtlasLoadingOption option = new AtlasLoadingOption();
        option.setCountrySlicing(false);
        option.setWaySectioning(true);
        return option;
    }

    public static AtlasLoadingOption withNoFilter() {
        StringResource pbfFilter = new StringResource("{\"filters\":[]}");
        ConfiguredTaggableFilter filter = new ConfiguredTaggableFilter(new StandardConfiguration(pbfFilter));
        AtlasLoadingOption atlasLoadingOption = new AtlasLoadingOption();
        atlasLoadingOption.setOsmPbfWayFilter(filter);
        atlasLoadingOption.setOsmPbfNodeFilter(filter);
        atlasLoadingOption.setOsmPbfRelationFilter(filter);
        atlasLoadingOption.setWaySectioning(true);
        return atlasLoadingOption;
    }

    private AtlasLoadingOption() {
    }

    public ConfiguredTaggableFilter getAreaFilter() {
        return this.areaFilter;
    }

    public CountryBoundaryMap getCountryBoundaryMap() {
        return this.countryBoundaryMap;
    }

    public Set<String> getCountryCodes() {
        return this.countryCodes;
    }

    public ConfiguredTaggableFilter getEdgeFilter() {
        return this.edgeFilter;
    }

    public ConfiguredTaggableFilter getForceSlicingFilter() {
        return this.forceSlicingFilter;
    }

    public ConfiguredTaggableFilter getOsmPbfNodeFilter() {
        return this.osmPbfNodeFilter;
    }

    public ConfiguredTaggableFilter getOsmPbfRelationFilter() {
        return this.osmPbfRelationFilter;
    }

    public ConfiguredTaggableFilter getOsmPbfWayFilter() {
        return this.osmPbfWayFilter;
    }

    public ConfiguredTaggableFilter getRelationSlicingFilter() {
        return this.relationSlicingFilter;
    }

    public ConfiguredTaggableFilter getWaySectionFilter() {
        return this.waySectionFilter;
    }

    public boolean isCountrySlicing() {
        return this.countrySlicing;
    }

    public boolean isLoadAtlasArea() {
        return this.loadAtlasArea;
    }

    public boolean isLoadAtlasEdge() {
        return this.loadAtlasEdge;
    }

    public boolean isLoadAtlasLine() {
        return this.loadAtlasLine;
    }

    public boolean isLoadAtlasNode() {
        return this.loadAtlasNode;
    }

    public boolean isLoadAtlasPoint() {
        return this.loadAtlasPoint;
    }

    public boolean isLoadAtlasRelation() {
        return this.loadAtlasRelation;
    }

    public boolean isLoadOsmBound() {
        return this.loadOsmBound;
    }

    public boolean isLoadOsmNode() {
        return this.isLoadAtlasNode() || this.isLoadAtlasPoint();
    }

    public boolean isLoadOsmRelation() {
        return this.isLoadAtlasRelation();
    }

    public boolean isLoadOsmWay() {
        return this.isLoadAtlasEdge() || this.isLoadAtlasLine();
    }

    public boolean isLoadWaysSpanningCountryBoundaries() {
        return this.loadWaysSpanningCountryBoundaries;
    }

    public boolean isWaySectioning() {
        return this.waySectioning;
    }

    public AtlasLoadingOption setAdditionalCountryCodes(Iterable<String> countryCodes) {
        this.countryCodes.addAll(Iterables.asSet(countryCodes));
        return this;
    }

    public AtlasLoadingOption setAdditionalCountryCodes(String ... countryCodes) {
        return this.setAdditionalCountryCodes(Iterables.asSet(countryCodes));
    }

    public void setAreaFilter(ConfiguredTaggableFilter areaFilter) {
        this.areaFilter = areaFilter;
    }

    public void setCountryBoundaryMap(CountryBoundaryMap countryBoundaryMap) {
        this.countryBoundaryMap = countryBoundaryMap;
    }

    public AtlasLoadingOption setCountrySlicing(boolean isCountrySlicing) {
        this.countrySlicing = isCountrySlicing;
        return this;
    }

    public void setEdgeFilter(ConfiguredTaggableFilter edgeFilter) {
        this.edgeFilter = edgeFilter;
    }

    public void setForceSlicingFilter(ConfiguredTaggableFilter forceSlicingFilter) {
        this.forceSlicingFilter = forceSlicingFilter;
    }

    public AtlasLoadingOption setLoadAtlasArea(boolean isLoadAtlasArea) {
        this.loadAtlasArea = isLoadAtlasArea;
        return this;
    }

    public AtlasLoadingOption setLoadAtlasEdge(boolean isLoadAtlasEdge) {
        this.loadAtlasEdge = isLoadAtlasEdge;
        return this;
    }

    public AtlasLoadingOption setLoadAtlasLine(boolean isLoadAtlasLine) {
        this.loadAtlasLine = isLoadAtlasLine;
        return this;
    }

    public AtlasLoadingOption setLoadAtlasNode(boolean isLoadAtlasNode) {
        this.loadAtlasNode = isLoadAtlasNode;
        return this;
    }

    public AtlasLoadingOption setLoadAtlasPoint(boolean isLoadAtlasPoint) {
        this.loadAtlasPoint = isLoadAtlasPoint;
        return this;
    }

    public AtlasLoadingOption setLoadAtlasRelation(boolean isLoadAtlasRelation) {
        this.loadAtlasRelation = isLoadAtlasRelation;
        return this;
    }

    public AtlasLoadingOption setLoadOsmBound(boolean isLoadOsmBound) {
        this.loadOsmBound = isLoadOsmBound;
        return this;
    }

    public AtlasLoadingOption setLoadWaysSpanningCountryBoundaries(boolean loadWaysSpanningCountryBoundaries) {
        this.loadWaysSpanningCountryBoundaries = loadWaysSpanningCountryBoundaries;
        return this;
    }

    public void setOsmPbfNodeFilter(ConfiguredTaggableFilter osmPbfNodeFilter) {
        this.osmPbfNodeFilter = osmPbfNodeFilter;
    }

    public void setOsmPbfRelationFilter(ConfiguredTaggableFilter osmPbfRelationFilter) {
        this.osmPbfRelationFilter = osmPbfRelationFilter;
    }

    public void setOsmPbfWayFilter(ConfiguredTaggableFilter osmPbfWayFilter) {
        this.osmPbfWayFilter = osmPbfWayFilter;
    }

    public void setRelationSlicingFilter(ConfiguredTaggableFilter relationSlicingFilter) {
        this.relationSlicingFilter = relationSlicingFilter;
    }

    public void setWaySectionFilter(ConfiguredTaggableFilter waySectionFilter) {
        this.waySectionFilter = waySectionFilter;
    }

    public AtlasLoadingOption setWaySectioning(boolean isWaySectioning) {
        this.waySectioning = isWaySectioning;
        return this;
    }
}

