/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.MultiNode;
import org.openstreetmap.atlas.geography.atlas.multi.SubEdgeList;

public class MultiEdge
extends Edge {
    private static final long serialVersionUID = -3986525201031430336L;
    private final long identifier;
    private SubEdgeList subEdgeList;

    protected MultiEdge(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.getRepresentativeSubEdge().asPolyLine();
    }

    @Override
    public Node end() {
        return new MultiNode(this.multiAtlas(), this.masteriseNodeIdentifier(this.getRepresentativeSubEdge().end().getIdentifier()));
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRepresentativeSubEdge().getTags();
    }

    @Override
    public Set<Relation> relations() {
        AbstractSet unionOfAllParentRelations = new HashSet<Relation>();
        for (Edge subEdge : this.getSubEdges().getSubEdges()) {
            Set<Relation> currentSubEdgeParentRelations = this.multiAtlas().multifyRelations(subEdge);
            unionOfAllParentRelations = Sets.union(unionOfAllParentRelations, currentSubEdgeParentRelations);
        }
        return unionOfAllParentRelations;
    }

    @Override
    public Node start() {
        return new MultiNode(this.multiAtlas(), this.masteriseNodeIdentifier(this.getRepresentativeSubEdge().start().getIdentifier()));
    }

    private Edge getRepresentativeSubEdge() {
        return this.getSubEdges().getSubEdges().get(0);
    }

    private SubEdgeList getSubEdges() {
        if (this.subEdgeList == null) {
            this.subEdgeList = this.multiAtlas().subEdge(this.identifier);
        }
        return this.subEdgeList;
    }

    private Long masteriseNodeIdentifier(long identifier) {
        Optional<Long> masterNodeIdentifier = this.multiAtlas().masterNode(identifier);
        if (masterNodeIdentifier.isPresent()) {
            return masterNodeIdentifier.get();
        }
        return identifier;
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

