/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.statistic.storeless.CounterWithStatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAtlasLoaderCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(MultiAtlasLoaderCommand.class);
    private static final Command.Switch<Atlas> FOLDER = new Command.Switch("folder", "Folder containing the atlas files", path -> new AtlasResourceLoader().load(new File((String)path)), Command.Optionality.REQUIRED);
    private static final Command.Switch<String> OUTPUT = new Command.Switch<String>("output", "output atlas file", StringConverter.IDENTITY, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new MultiAtlasLoaderCommand().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        CounterWithStatistic statistics = new CounterWithStatistic(logger);
        Atlas multi = (Atlas)command.get(FOLDER);
        File output = new File((String)command.get(OUTPUT));
        statistics.summary();
        PackedAtlas packed = PackedAtlas.cloneFrom(multi);
        packed.save(output);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(FOLDER, OUTPUT);
    }
}

