/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;

public class WaterConfigurationHandler {
    public static final String WATER_RESOURCE = "water-handlers.json";
    private final Configuration waterHandlerConfiguration;
    private final Map<String, ConfiguredFilter> waterHandlers;

    public WaterConfigurationHandler() {
        this(new InputStreamResource(() -> WaterConfigurationHandler.class.getResourceAsStream(WATER_RESOURCE)));
    }

    public WaterConfigurationHandler(Resource resource) {
        this(new StandardConfiguration(resource));
    }

    public WaterConfigurationHandler(Configuration configuration) {
        this.waterHandlerConfiguration = configuration;
        this.waterHandlers = this.readConfiguration();
    }

    public Configuration getWaterHandlerConfiguration() {
        return this.waterHandlerConfiguration;
    }

    public Map<String, ConfiguredFilter> getWaterHandlers() {
        return this.waterHandlers;
    }

    private Map<String, ConfiguredFilter> readConfiguration() {
        HashMap<String, ConfiguredFilter> waterHandlers = new HashMap<String, ConfiguredFilter>();
        ConfigurationReader reader = new ConfigurationReader("global.filters");
        Set waterBodyTypes = reader.configurationValue(this.waterHandlerConfiguration, Map::keySet);
        waterBodyTypes.forEach(waterBodyType -> waterHandlers.put(waterBodyType.toLowerCase(), ConfiguredFilter.from(waterBodyType, this.waterHandlerConfiguration)));
        return waterHandlers;
    }
}

