/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterbody;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterway;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterConfigurationHandler;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaterEntityFinder
implements Finder<ComplexWaterEntity> {
    public static final String WATER_RESOURCE = "water-handlers.json";
    private static final Predicate<Relation> RELATION_FILTER = relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON, RelationTypeTag.BOUNDARY, RelationTypeTag.WATERWAY});
    private static final Logger logger = LoggerFactory.getLogger(ComplexWaterEntityFinder.class);
    private final WaterConfigurationHandler waterConfigurationHandler;

    public ComplexWaterEntityFinder() {
        this(new InputStreamResource(() -> ComplexWaterEntityFinder.class.getResourceAsStream(WATER_RESOURCE)));
    }

    public ComplexWaterEntityFinder(Resource resource) {
        this.waterConfigurationHandler = new WaterConfigurationHandler(resource);
    }

    @Override
    public Iterable<ComplexWaterEntity> find(Atlas atlas) {
        Iterable areaEntities = Iterables.translateMulti(atlas.areas(), this::processEntity);
        Iterable lineEntities = Iterables.translateMulti(atlas.lineItems(), this::processEntity);
        Iterable relationEntities = Iterables.translateMulti(atlas.relations(RELATION_FILTER), this::processEntity);
        return new MultiIterable<ComplexWaterEntity>(areaEntities, lineEntities, relationEntities);
    }

    public WaterConfigurationHandler getWaterConfigurationHandler() {
        return this.waterConfigurationHandler;
    }

    public List<ComplexWaterEntity> processEntity(AtlasObject object) {
        ArrayList<ComplexWaterEntity> complexWaterEntities = new ArrayList<ComplexWaterEntity>();
        if (object instanceof AtlasEntity) {
            AtlasEntity entity = (AtlasEntity)object;
            this.waterConfigurationHandler.getWaterHandlers().forEach((waterBodyType, configuredFilter) -> {
                if (configuredFilter.test(entity)) {
                    try {
                        if (entity instanceof Relation || entity instanceof Area) {
                            complexWaterEntities.add(new ComplexWaterbody(entity, (String)waterBodyType));
                        } else if (entity instanceof Line) {
                            complexWaterEntities.add(new ComplexWaterway(entity, (String)waterBodyType));
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Skipping entity : {}", (Object)entity, (Object)e);
                    }
                }
            });
        }
        if (complexWaterEntities.isEmpty()) {
            logger.debug("Could not create complex water entity from {} with osm id {}", (Object)object.getIdentifier(), (Object)object.getOsmIdentifier());
        }
        return complexWaterEntities;
    }
}

