/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.slf4j.Logger;

public abstract class ComplexWaterEntity
extends ComplexEntity {
    private static final long serialVersionUID = 7835788819725148174L;
    private final String waterType;

    public ComplexWaterEntity(AtlasEntity source, String waterType) {
        super(source);
        this.waterType = waterType;
        try {
            this.populateGeometry();
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to create complex water entity from {}", (Object)source, (Object)e);
            this.setInvalidReason("Unable to create complex water entity", e);
        }
    }

    public String getWaterType() {
        return this.waterType;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.getWaterType() + " " + this.getSource();
    }

    protected abstract Logger getLogger();

    protected abstract void populateGeometry();
}

