/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.islands;

import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.islands.ComplexIsland;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntityFinder;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterConfigurationHandler;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;

public class ComplexIslandFinder
implements Finder<ComplexIsland> {
    private static final Set<String> ACCEPTABLE_WATER_FEATURES = Sets.hashSet("lake", "river", "reservoir");
    private final WaterConfigurationHandler waterConfigurationHandler;

    public ComplexIslandFinder() {
        this(new InputStreamResource(() -> ComplexWaterEntityFinder.class.getResourceAsStream("water-handlers.json")));
    }

    public ComplexIslandFinder(Resource resource) {
        this.waterConfigurationHandler = new WaterConfigurationHandler(resource);
    }

    @Override
    public Iterable<ComplexIsland> find(Atlas atlas) {
        Iterable<Relation> relations = atlas.relations(relation -> relation.isMultiPolygon() && relation.hasMultiPolygonMembers(Relation.Ring.INNER) && this.testWaterType((Relation)relation));
        return Iterables.translate(relations, ComplexIsland::new);
    }

    private boolean testWaterType(Relation relation) {
        return this.waterConfigurationHandler.getWaterHandlers().entrySet().stream().filter(entry -> ACCEPTABLE_WATER_FEATURES.contains(entry.getKey())).anyMatch(entry -> ((ConfiguredFilter)entry.getValue()).test(relation));
    }
}

