/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.islands;

import java.util.ArrayList;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexIsland
extends ComplexEntity {
    private static final long serialVersionUID = 7840944233946510730L;
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final Logger logger = LoggerFactory.getLogger(ComplexIsland.class);
    private MultiPolygon multiPolygon;

    public ComplexIsland(AtlasEntity source) {
        super(source);
        try {
            this.populateGeometry();
        }
        catch (Exception e) {
            logger.warn("Unable to create complex islands from {}", (Object)source, (Object)e);
            this.setInvalidReason("Unable to create complex islands", e);
        }
    }

    public MultiPolygon getGeometry() {
        return this.multiPolygon;
    }

    @Override
    public String toString() {
        return "Island : " + this.getSource();
    }

    private void populateGeometry() {
        Relation relation;
        String type;
        AtlasEntity source = this.getSource();
        if (source instanceof Relation && "multipolygon".equals(type = (relation = (Relation)source).tag("type"))) {
            MultiPolygon multiPolygon = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(relation);
            MultiMap<Polygon, Polygon> outerToInners = new MultiMap<Polygon, Polygon>();
            for (Polygon inner : multiPolygon.inners()) {
                outerToInners.put(inner, new ArrayList());
            }
            this.multiPolygon = new MultiPolygon(outerToInners);
            return;
        }
        throw new CoreException("Geometry is not set for {}", source);
    }
}

