/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.bignode;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.BigNode;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.names.NameFinder;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.direction.EdgeDirectionComparator;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigNodeFinder
implements Finder<BigNode> {
    private static final int MIN_MASTER_EDGE_DUAL_CARRIAGEWAY_INTERSECTION = 2;
    private static final int LEVENSHTEIN_DISTANCE_THRESHOLD = 1;
    private static final Logger logger = LoggerFactory.getLogger(BigNodeFinder.class);
    private static final Distance SEARCH_RADIUS_MOTORWAY = Distance.meters(70.0);
    private static final Distance SEARCH_RADIUS_TRUNK = Distance.meters(60.0);
    private static final Distance SEARCH_RADIUS_PRIMARY = Distance.meters(50.0);
    private static final Distance SEARCH_RADIUS_SECONDARY = Distance.meters(40.0);
    private static final Distance SEARCH_RADIUS_TERTIARY = Distance.meters(35.0);
    private static final Distance SEARCH_RADIUS_RESIDENTIAL = Distance.meters(25.0);
    private static final int MAXIMUM_DUAL_CARRIAGEWAY_ROUTE_SIZE = 10;
    private static final int MAXIMUM_CANDIDATE_JUNCTION_ROUTE_SET_SIZE = 10000;
    private final EdgeDirectionComparator edgeDirectionComparator = new EdgeDirectionComparator();
    private final NameFinder nameFinder = new NameFinder().withTags(NameFinder.STANDARD_TAGS);

    @Override
    public Iterable<BigNode> find(Atlas atlas) {
        TreeSet<Long> junctionEdgeIds = new TreeSet<Long>();
        TreeSet junctionRouteEdgeIds = new TreeSet();
        for (Edge candidateEdge : atlas.edges(this::isCandidateJunctionEdge)) {
            if (junctionEdgeIds.contains(candidateEdge.getIdentifier())) continue;
            if (this.isDualCarriageWayJunctionEdge(candidateEdge)) {
                junctionEdgeIds.add(candidateEdge.getIdentifier());
                continue;
            }
            Optional<Route> junctionRoute = this.isDualCarriageWayJunctionRoute(Route.forEdge(candidateEdge));
            junctionRoute.ifPresent(route -> {
                Edge startEdge = route.start();
                junctionRouteEdgeIds.add(startEdge.getIdentifier());
                route.forEach(edge -> junctionEdgeIds.add(edge.getIdentifier()));
            });
        }
        HashMap<Long, BigNodeCandidate> nodeIdToBigNodeCandidateMap = new HashMap<Long, BigNodeCandidate>();
        while (!junctionEdgeIds.isEmpty()) {
            Long candidateEdgeId = junctionRouteEdgeIds.isEmpty() ? (Long)junctionEdgeIds.iterator().next() : (Long)junctionRouteEdgeIds.iterator().next();
            Edge candidate = atlas.edge(candidateEdgeId);
            Route mergedCandidate = this.mergeJunctionEdges(Route.forEdge(candidate), junctionEdgeIds);
            logger.debug("Merged bigNode Route : {}. Number of Edges : {}", (Object)mergedCandidate, (Object)mergedCandidate.size());
            HashSet<Node> nodes = new HashSet<Node>();
            mergedCandidate.forEach(edge -> nodes.addAll(edge.connectedNodes()));
            HashSet<BigNodeCandidate> bigNodesMergeCandidates = new HashSet<BigNodeCandidate>();
            for (Node node : nodes) {
                if (!nodeIdToBigNodeCandidateMap.containsKey(node.getIdentifier())) continue;
                bigNodesMergeCandidates.add((BigNodeCandidate)nodeIdToBigNodeCandidateMap.get(node.getIdentifier()));
            }
            BigNodeCandidate bigNodeCandidate = BigNodeCandidate.from(nodes);
            for (BigNodeCandidate mergeBigNode : bigNodesMergeCandidates) {
                bigNodeCandidate.merge(mergeBigNode);
            }
            for (Long nodeIdentifier : bigNodeCandidate.getNodeIdentifiers()) {
                nodeIdToBigNodeCandidateMap.put(nodeIdentifier, bigNodeCandidate);
            }
            mergedCandidate.forEach(edge -> junctionEdgeIds.remove(edge.getIdentifier()));
            mergedCandidate.forEach(edge -> junctionRouteEdgeIds.remove(edge.getIdentifier()));
        }
        HashSet<BigNodeCandidate> bigNodeCandidateSet = new HashSet<BigNodeCandidate>(nodeIdToBigNodeCandidateMap.values());
        logger.info("Atlas has {} DualCarriageWay bigNodes with {} subNodes. Total Number of Big Nodes (including Simple Intersections) : {}", new Object[]{bigNodeCandidateSet.size(), nodeIdToBigNodeCandidateMap.keySet().size(), atlas.numberOfNodes() - (long)nodeIdToBigNodeCandidateMap.keySet().size() + (long)bigNodeCandidateSet.size()});
        BigNodeIterator bigNodeIterator = new BigNodeIterator(atlas, bigNodeCandidateSet);
        return new BigNodeIterable(bigNodeIterator);
    }

    public void findAndSaveBigNodesAsGeoJson(Atlas atlas, WritableResource writableResource) {
        ArrayList<GeoJsonBuilder.LocationIterableProperties> features = new ArrayList<GeoJsonBuilder.LocationIterableProperties>();
        Iterables.stream(this.find(atlas)).map(BigNode::asGeoJsonBigNode).forEach(features::add);
        new GeoJsonBuilder().create(features).save(writableResource);
    }

    public void findAndSaveRestrictedPathsAsGeoJson(Atlas atlas, WritableResource writableResource) {
        ArrayList<GeoJsonBuilder.LocationIterableProperties> features = new ArrayList<GeoJsonBuilder.LocationIterableProperties>();
        Iterables.stream(this.find(atlas)).flatMap(BigNode::asGeoJsonRestrictedPath).forEach(features::add);
        new GeoJsonBuilder().create(features).save(writableResource);
    }

    private boolean edgeNameExactMatch(Edge edgeA, Edge edgeB, boolean strictMode) {
        Optional<String> edgeAName = this.nameFinder.best(edgeA);
        Optional<String> edgeBName = this.nameFinder.best(edgeB);
        if (edgeAName.isPresent() && edgeBName.isPresent()) {
            return this.nameExactMatch(edgeAName.get(), edgeBName.get());
        }
        return !strictMode && (!edgeAName.isPresent() || !edgeBName.isPresent());
    }

    private boolean edgeNameFuzzyMatch(Edge edgeA, Edge edgeB, boolean strictMode) {
        Optional<String> edgeAName = this.nameFinder.best(edgeA);
        Optional<String> edgeBName = this.nameFinder.best(edgeB);
        if (edgeAName.isPresent() && edgeBName.isPresent()) {
            return this.nameFuzzyMatch(edgeAName.get(), edgeBName.get());
        }
        return !strictMode && (!edgeAName.isPresent() || !edgeBName.isPresent());
    }

    private boolean isCandidateJunctionEdge(Edge edge) {
        HighwayTag highwayTag = edge.highwayTag();
        return this.isShortEnough(edge) && highwayTag.isMoreImportantThanOrEqualTo(HighwayTag.RESIDENTIAL) && !JunctionTag.isRoundabout(edge);
    }

    private boolean isDualCarriageWayJunctionEdge(Edge candidateEdge) {
        return this.isDualCarriageWayRoute(Route.forEdge(candidateEdge));
    }

    private Optional<Route> isDualCarriageWayJunctionRoute(Route candidateJunctionRoute) {
        LinkedHashSet<Route> candidateJunctionRoutes = new LinkedHashSet<Route>();
        candidateJunctionRoutes.add(candidateJunctionRoute);
        return this.isDualCarriageWayJunctionRoute(candidateJunctionRoutes);
    }

    private Optional<Route> isDualCarriageWayJunctionRoute(Set<Route> candidateJunctionRoutes) {
        if (candidateJunctionRoutes.size() > 10000) {
            logger.warn("Aborting isDualCarriageWayJunctionRoute, candidate set size {} exceeded {}", (Object)candidateJunctionRoutes.size(), (Object)10000);
            return Optional.empty();
        }
        if (candidateJunctionRoutes.isEmpty()) {
            return Optional.empty();
        }
        LinkedHashSet<Route> expandableJunctionRoutes = new LinkedHashSet<Route>();
        for (Route candidateJunctionRoute : candidateJunctionRoutes) {
            LinkedHashSet expandableEdges = new LinkedHashSet();
            candidateJunctionRoute.end().outEdges().stream().filter(this::isCandidateJunctionEdge).filter(edge -> edge.getMasterEdgeIdentifier() != candidateJunctionRoute.end().getMasterEdgeIdentifier()).filter(edge -> this.edgeDirectionComparator.isSameDirection(candidateJunctionRoute.end(), (Edge)edge, false)).forEach(expandableEdges::add);
            for (Edge expandableEdge : expandableEdges) {
                Route route = null;
                try {
                    route = candidateJunctionRoute.append(expandableEdge);
                }
                catch (CoreException e) {
                    throw new CoreException("Could not append dual carriageway route {} with {}", candidateJunctionRoute, expandableEdge.getIdentifier(), e);
                }
                if (this.isDualCarriageWayRoute(route)) {
                    logger.debug("Adding Dual Carriageway Junction Route : {}", (Object)route);
                    return Optional.of(route);
                }
                if (route.size() <= 10) {
                    expandableJunctionRoutes.add(route);
                    continue;
                }
                logger.trace("Maximum number of edges in dual carriageway route  ({}) reached. Skipping route : {}", (Object)10, (Object)route);
            }
        }
        return this.isDualCarriageWayJunctionRoute(expandableJunctionRoutes);
    }

    private boolean isDualCarriageWayRoute(Route candidateRoute) {
        if (candidateRoute == null) {
            return false;
        }
        if (candidateRoute.connectedEdges().stream().filter(Edge::isMasterEdge).count() >= 2L) {
            for (Edge inEdge : candidateRoute.start().inEdges()) {
                if (inEdge.highwayTag().isLessImportantThan(HighwayTag.RESIDENTIAL) || this.edgeDirectionComparator.isSameDirection(candidateRoute.start(), inEdge, false) || this.edgeNameFuzzyMatch(candidateRoute.start(), inEdge, true)) continue;
                for (Edge outEdge : candidateRoute.end().outEdges()) {
                    if (outEdge.highwayTag().isMoreImportantThanOrEqualTo(HighwayTag.UNCLASSIFIED) && this.edgeDirectionComparator.isOppositeDirection(inEdge, outEdge, false) && !outEdge.hasReverseEdge() && !inEdge.hasReverseEdge() && this.edgeNameFuzzyMatch(outEdge, inEdge, false)) {
                        return true;
                    }
                    if (outEdge.highwayTag() != HighwayTag.RESIDENTIAL || !this.edgeDirectionComparator.isOppositeDirection(inEdge, outEdge, false) || outEdge.hasReverseEdge() || inEdge.hasReverseEdge() || !this.edgeNameExactMatch(outEdge, inEdge, inEdge.highwayTag() != HighwayTag.RESIDENTIAL)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMergeCandidateEdge(Edge candidateEdge, Route candidateRoute, Set<Long> junctionEdgeIds) {
        if (this.isCandidateJunctionEdge(candidateEdge)) {
            HashSet<Edge> candidateRouteEdges = Sets.newHashSet(candidateRoute);
            Set candidateRouteEdgeIds = candidateRouteEdges.stream().map(edge -> edge.getIdentifier()).collect(Collectors.toSet());
            Sets.SetView<Long> filteredJunctionEdgeIds = Sets.difference(junctionEdgeIds, candidateRouteEdgeIds);
            for (Edge edge2 : candidateEdge.outEdges()) {
                if (!filteredJunctionEdgeIds.contains(edge2.getIdentifier()) || !this.edgeNameFuzzyMatch(candidateRoute.end(), edge2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isShortEnough(Edge edge) {
        Distance length = edge.length();
        if (SEARCH_RADIUS_MOTORWAY.isLessThanOrEqualTo(length)) {
            return false;
        }
        HighwayTag highwayTag = this.mostSignificantConnectedHighwayType(edge);
        return this.searchRadius(highwayTag).isGreaterThan(length);
    }

    private Route mergeJunctionEdges(Route candidateRoute, Set<Long> junctionEdgeIds) {
        if (candidateRoute.start().start().equals(candidateRoute.end().end())) {
            return candidateRoute;
        }
        Set<Edge> connectedEdges = candidateRoute.end().outEdges();
        connectedEdges.addAll(candidateRoute.start().inEdges());
        TreeSet mergeCandidates = new TreeSet((edge1, edge2) -> ComparisonChain.start().compare(edge1.getIdentifier(), edge2.getIdentifier()).result());
        HashSet masterEdgeIdentifiers = new HashSet();
        candidateRoute.forEach(edge -> masterEdgeIdentifiers.add(edge.getMasterEdgeIdentifier()));
        connectedEdges.stream().filter(edge -> junctionEdgeIds.contains(edge.getIdentifier())).filter(edge -> !candidateRoute.includes((Edge)edge)).filter(edge -> !masterEdgeIdentifiers.contains(edge.getMasterEdgeIdentifier())).forEach(mergeCandidates::add);
        if (mergeCandidates.isEmpty()) {
            connectedEdges.stream().filter(edge -> !junctionEdgeIds.contains(edge.getIdentifier())).filter(edge -> !masterEdgeIdentifiers.contains(edge.getMasterEdgeIdentifier())).filter(edge -> this.isMergeCandidateEdge((Edge)edge, candidateRoute, junctionEdgeIds)).filter(edge -> !candidateRoute.includes((Edge)edge)).forEach(mergeCandidates::add);
        }
        if (!mergeCandidates.isEmpty()) {
            for (Edge mergeCandidate : mergeCandidates) {
                Set<Edge> connectedEdge = Collections.singleton(mergeCandidate);
                if (candidateRoute.end().isConnectedAtEndTo(connectedEdge)) {
                    return this.mergeJunctionEdges(candidateRoute.append(mergeCandidate), junctionEdgeIds);
                }
                if (!candidateRoute.start().isConnectedAtStartTo(connectedEdge)) continue;
                return this.mergeJunctionEdges(Route.forEdge(mergeCandidate).append(candidateRoute), junctionEdgeIds);
            }
        }
        return candidateRoute;
    }

    private HighwayTag mostSignificantConnectedHighwayType(Edge edge) {
        HighwayTag edgeTag = edge.highwayTag();
        for (Edge connected : edge.connectedEdges()) {
            HighwayTag connectedTag = connected.highwayTag();
            if (!connectedTag.isMoreImportantThan(edgeTag)) continue;
            edgeTag = connectedTag;
        }
        return edgeTag;
    }

    private boolean nameExactMatch(String nameA, String nameB) {
        return nameA.equalsIgnoreCase(nameB);
    }

    private boolean nameFuzzyMatch(String nameA, String nameB) {
        return nameA.equalsIgnoreCase(nameB) || StringUtils.getLevenshteinDistance(nameA, nameB, 1) != -1;
    }

    private Distance searchRadius(HighwayTag highwayTag) {
        if (highwayTag == HighwayTag.MOTORWAY || highwayTag == HighwayTag.MOTORWAY_LINK) {
            return SEARCH_RADIUS_MOTORWAY;
        }
        if (highwayTag == HighwayTag.TRUNK || highwayTag == HighwayTag.TRUNK_LINK) {
            return SEARCH_RADIUS_TRUNK;
        }
        if (highwayTag == HighwayTag.PRIMARY || highwayTag == HighwayTag.PRIMARY_LINK) {
            return SEARCH_RADIUS_PRIMARY;
        }
        if (highwayTag == HighwayTag.SECONDARY || highwayTag == HighwayTag.SECONDARY_LINK) {
            return SEARCH_RADIUS_SECONDARY;
        }
        if (highwayTag == HighwayTag.TERTIARY || highwayTag == HighwayTag.TERTIARY_LINK) {
            return SEARCH_RADIUS_TERTIARY;
        }
        return SEARCH_RADIUS_RESIDENTIAL;
    }

    public class BigNodeIterator
    extends AbstractIterator<BigNode> {
        private final Iterator<BigNodeCandidate> bigNodeCandidateIterator;
        private final Atlas atlas;
        private final Iterator<Node> nodeIterator;
        private final Set<Long> bigNodeIdentifiers;

        public BigNodeIterator(Atlas atlas, Set<BigNodeCandidate> bigNodeCandidates) {
            this.atlas = atlas;
            this.bigNodeCandidateIterator = bigNodeCandidates.iterator();
            this.nodeIterator = this.atlas.nodes().iterator();
            this.bigNodeIdentifiers = new HashSet<Long>();
        }

        @Override
        protected BigNode computeNext() {
            while (this.bigNodeCandidateIterator.hasNext()) {
                BigNodeCandidate bigNodeCandidate = this.bigNodeCandidateIterator.next();
                TreeSet<Node> nodes = new TreeSet<Node>((node1, node2) -> new CompareToBuilder().append(node1.getIdentifier(), node2.getIdentifier()).toComparison());
                bigNodeCandidate.nodeIdentifiers.forEach(nodeIdentifier -> nodes.add(this.atlas.node((long)nodeIdentifier)));
                if (nodes.isEmpty()) continue;
                Node sourceNode = (Node)nodes.iterator().next();
                BigNode bigNode = new BigNode(sourceNode, nodes, BigNode.Type.DUAL_CARRIAGEWAY);
                nodes.stream().forEach(node -> this.bigNodeIdentifiers.add(node.getIdentifier()));
                return bigNode;
            }
            while (this.nodeIterator.hasNext()) {
                Node candidateNode = this.nodeIterator.next();
                if (this.bigNodeIdentifiers.contains(candidateNode.getIdentifier()) || !candidateNode.connectedEdges().stream().anyMatch(HighwayTag::isCarNavigableHighway)) continue;
                this.bigNodeIdentifiers.add(candidateNode.getIdentifier());
                return new BigNode(candidateNode);
            }
            return (BigNode)this.endOfData();
        }
    }

    public class BigNodeIterable
    implements Iterable<BigNode> {
        private final BigNodeIterator iterator;

        public BigNodeIterable(BigNodeIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<BigNode> iterator() {
            return this.iterator;
        }
    }

    public static final class BigNodeCandidate
    implements Comparable<BigNodeCandidate>,
    Serializable {
        private static final long serialVersionUID = 7225634482602225746L;
        private final Set<Long> nodeIdentifiers;

        public static BigNodeCandidate from(Set<Node> nodes) {
            return new BigNodeCandidate(nodes.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
        }

        public BigNodeCandidate() {
            this.nodeIdentifiers = new TreeSet<Long>();
        }

        public BigNodeCandidate(Set<Long> nodeIds) {
            this.nodeIdentifiers = new TreeSet<Long>(nodeIds);
        }

        @Override
        public int compareTo(BigNodeCandidate bigNodeCandidate) {
            return new CompareToBuilder().append(this.nodeIdentifiers, bigNodeCandidate.nodeIdentifiers).toComparison();
        }

        public boolean equals(Object other) {
            if (other instanceof BigNodeCandidate) {
                BigNodeCandidate that = (BigNodeCandidate)other;
                if (this.nodeIdentifiers.size() == that.nodeIdentifiers.size()) {
                    return new EqualsBuilder().append(this.nodeIdentifiers, that.nodeIdentifiers).isEquals();
                }
            }
            return false;
        }

        public Set<Long> getNodeIdentifiers() {
            return this.nodeIdentifiers;
        }

        public long getSourceNodeIdentifier() {
            if (!this.nodeIdentifiers.isEmpty()) {
                return this.nodeIdentifiers.iterator().next();
            }
            throw new IllegalArgumentException("Could not get source node identifier since nodesIdentifiers are empty");
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.nodeIdentifiers).hashCode();
        }

        public void merge(BigNodeCandidate mergeBigNodeCandidate) {
            this.nodeIdentifiers.addAll(mergeBigNodeCandidate.nodeIdentifiers);
        }
    }
}

