/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex;

import java.util.ArrayList;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationToMultiPolygonMemberConverter;
import org.openstreetmap.atlas.utilities.conversion.Converter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;

public class RelationOrAreaToMultiPolygonConverter
implements Converter<AtlasEntity, MultiPolygon> {
    private static final RelationToMultiPolygonMemberConverter OUTER_CONVERTER = new RelationToMultiPolygonMemberConverter(Relation.Ring.OUTER);
    private static final RelationToMultiPolygonMemberConverter INNER_CONVERTER = new RelationToMultiPolygonMemberConverter(Relation.Ring.INNER);

    @Override
    public MultiPolygon convert(AtlasEntity entity) {
        if (entity instanceof Relation) {
            Relation relation = (Relation)entity;
            if (relation.isMultiPolygon()) {
                MultiMap<Polygon, Polygon> outerToInners = new MultiMap<Polygon, Polygon>();
                for (Polygon outer : OUTER_CONVERTER.convert(relation)) {
                    outerToInners.put(outer, new ArrayList());
                }
                if (outerToInners.isEmpty()) {
                    throw new CoreException("Unable to find outer polygon.");
                }
                for (Polygon inner : INNER_CONVERTER.convert(relation)) {
                    boolean added = false;
                    for (Polygon outer : outerToInners.keySet()) {
                        if (!outer.overlaps(inner) || inner.fullyGeometricallyEncloses(outer)) continue;
                        outerToInners.add(outer, inner);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    throw new CoreException("Malformed MultiPolygon: inner has no outer host: {}", inner);
                }
                return new MultiPolygon(outerToInners);
            }
            throw new CoreException("This is not a multipolygon relation");
        }
        if (entity instanceof Area) {
            return MultiPolygon.forPolygon(((Area)entity).asPolygon());
        }
        throw new CoreException("The outline is not an area nor a relation: {}", entity);
    }
}

