/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.ConnectedEdgeType;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;

public abstract class Node
extends LocationItem {
    private static final long serialVersionUID = 2082593591946379000L;

    protected Node(Atlas atlas) {
        super(atlas);
    }

    public long absoluteValence() {
        return this.connectedEdges().size();
    }

    public SortedSet<Edge> connectedEdges() {
        TreeSet<Edge> result = new TreeSet<Edge>();
        result.addAll(this.inEdges());
        result.addAll(this.outEdges());
        return result;
    }

    public SortedSet<Edge> connectedEdges(ConnectedEdgeType connectedEdgeType) {
        Validate.notNull(connectedEdgeType);
        SortedSet<Edge> connectedEdges = connectedEdgeType.getAccessFunction().apply(this);
        return connectedEdges;
    }

    @Override
    public JsonObject getGeoJsonProperties() {
        JsonObject properties = super.getGeoJsonProperties();
        JsonArray inEdgesArray = new JsonArray();
        JsonArray outEdgesArray = new JsonArray();
        for (Edge edge : this.inEdges()) {
            inEdgesArray.add(new JsonPrimitive(edge.getIdentifier()));
        }
        for (Edge edge : this.outEdges()) {
            outEdgesArray.add(new JsonPrimitive(edge.getIdentifier()));
        }
        properties.add(ConnectedEdgeType.IN.getPropertyName(), inEdgesArray);
        properties.add(ConnectedEdgeType.OUT.getPropertyName(), outEdgesArray);
        return properties;
    }

    @Override
    public ItemType getType() {
        return ItemType.NODE;
    }

    public abstract SortedSet<Edge> inEdges();

    public abstract SortedSet<Edge> outEdges();

    @Override
    public String toDiffViewFriendlyString() {
        String relationsString = this.parentRelationsAsDiffViewFriendlyString();
        return "[Node: id=" + this.getIdentifier() + ", location=" + this.getLocation() + ", inEdges=" + this.connectedEdgesIdentifiers(() -> this.inEdges()) + ", outEdges=" + this.connectedEdgesIdentifiers(() -> this.outEdges()) + ", relations=(" + relationsString + "), " + this.tagString() + "]";
    }

    public String toString() {
        return "[Node: id=" + this.getIdentifier() + ", location=" + this.getLocation() + ", inEdges=" + this.connectedEdgesIdentifiers(() -> this.inEdges()) + ", outEdges=" + this.connectedEdgesIdentifiers(() -> this.outEdges()) + ", " + this.tagString() + "]";
    }

    public long valence() {
        return this.connectedEdges().stream().filter(Edge::isMasterEdge).count();
    }

    private SortedSet<Long> connectedEdgesIdentifiers(Supplier<SortedSet<Edge>> getConnectedEdges) {
        TreeSet<Long> result = new TreeSet<Long>();
        getConnectedEdges.get().forEach(edge -> result.add(edge.getIdentifier()));
        return result;
    }
}

